/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.plain;

import java.io.IOException;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.bytes.BytesUtils;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.values.ValuesReader;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.ParquetDecodingException;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryPlainValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryPlainValuesReader.class);
    private ByteBufferInputStream in;

    @Override
    public Binary readBytes() {
        try {
            int length = BytesUtils.readIntLittleEndian(this.in);
            return Binary.fromConstantByteBuffer(this.in.slice(length));
        }
        catch (IOException | RuntimeException e) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.in.position(), e);
        }
    }

    @Override
    public void skip() {
        try {
            int length = BytesUtils.readIntLittleEndian(this.in);
            this.in.skipFully(length);
        }
        catch (IOException | RuntimeException e) {
            throw new ParquetDecodingException("could not skip bytes at offset " + this.in.position(), e);
        }
    }

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream stream) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)stream.position(), (Object)((long)stream.available() - stream.position()));
        this.in = stream.remainingStream();
    }
}

