/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import java.io.IOException;
import retrofit2.Converter;
import shaded.okhttp3.ResponseBody;
import shaded.okio.BufferedSource;
import shaded.okio.ByteString;

final class MoshiResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private static final ByteString UTF8_BOM = ByteString.decodeHex("EFBBBF");
    private final JsonAdapter<T> adapter;

    MoshiResponseBodyConverter(JsonAdapter<T> adapter) {
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T convert(ResponseBody value) throws IOException {
        BufferedSource source2 = value.source();
        try {
            if (source2.rangeEquals(0L, UTF8_BOM)) {
                source2.skip(UTF8_BOM.size());
            }
            JsonReader reader = JsonReader.of(source2);
            T result = this.adapter.fromJson(reader);
            if (reader.peek() != JsonReader.Token.END_DOCUMENT) {
                throw new JsonDataException("JSON document was not fully consumed.");
            }
            T t = result;
            return t;
        }
        finally {
            value.close();
        }
    }
}

