/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.influxdb.sink;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.InfluxDBConfig;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.influxdb.sink.InfluxDBSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Factory.class})
public class InfluxDBSinkFactory
implements TableSinkFactory {
    private static final Logger log = LoggerFactory.getLogger(InfluxDBSinkFactory.class);

    public String factoryIdentifier() {
        return "InfluxDB";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{InfluxDBConfig.URL, InfluxDBConfig.DATABASES}).bundled(new Option[]{InfluxDBConfig.USERNAME, InfluxDBConfig.PASSWORD}).optional(new Option[]{InfluxDBConfig.CONNECT_TIMEOUT_MS, SinkConfig.KEY_MEASUREMENT, SinkConfig.KEY_TAGS, SinkConfig.KEY_TIME, SinkConfig.BATCH_SIZE, SinkConfig.MAX_RETRIES, SinkConfig.RETRY_BACKOFF_MULTIPLIER_MS}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        ReadonlyConfig config = context.getOptions();
        CatalogTable catalogTable = context.getCatalogTable();
        if (!config.getOptional(SinkConfig.KEY_MEASUREMENT).isPresent()) {
            Map map = config.toMap();
            map.put(SinkConfig.KEY_MEASUREMENT.key(), catalogTable.getTableId().toTablePath().getFullName());
            config = ReadonlyConfig.fromMap(new HashMap(map));
        }
        SinkConfig sinkConfig = new SinkConfig(config.toConfig());
        return () -> new InfluxDBSink(sinkConfig, catalogTable);
    }
}

