/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonScope;
import com.squareup.moshi.JsonUtf8Writer;
import com.squareup.moshi.JsonValueWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import shaded.okio.BufferedSink;
import shaded.okio.BufferedSource;

public abstract class JsonWriter
implements Closeable,
Flushable {
    int stackSize = 0;
    int[] scopes = new int[32];
    String[] pathNames = new String[32];
    int[] pathIndices = new int[32];
    String indent;
    boolean lenient;
    boolean serializeNulls;
    boolean promoteValueToName;
    int flattenStackSize = -1;

    @CheckReturnValue
    public static JsonWriter of(BufferedSink sink2) {
        return new JsonUtf8Writer(sink2);
    }

    JsonWriter() {
    }

    final int peekScope() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.scopes[this.stackSize - 1];
    }

    final boolean checkStack() {
        if (this.stackSize != this.scopes.length) {
            return false;
        }
        if (this.stackSize == 256) {
            throw new JsonDataException("Nesting too deep at " + this.getPath() + ": circular reference?");
        }
        this.scopes = Arrays.copyOf(this.scopes, this.scopes.length * 2);
        this.pathNames = Arrays.copyOf(this.pathNames, this.pathNames.length * 2);
        this.pathIndices = Arrays.copyOf(this.pathIndices, this.pathIndices.length * 2);
        if (this instanceof JsonValueWriter) {
            ((JsonValueWriter)this).stack = Arrays.copyOf(((JsonValueWriter)this).stack, ((JsonValueWriter)this).stack.length * 2);
        }
        return true;
    }

    final void pushScope(int newTop) {
        this.scopes[this.stackSize++] = newTop;
    }

    final void replaceTop(int topOfStack) {
        this.scopes[this.stackSize - 1] = topOfStack;
    }

    public void setIndent(String indent) {
        this.indent = !indent.isEmpty() ? indent : null;
    }

    @CheckReturnValue
    public final String getIndent() {
        return this.indent != null ? this.indent : "";
    }

    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    @CheckReturnValue
    public final boolean isLenient() {
        return this.lenient;
    }

    public final void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    @CheckReturnValue
    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public abstract JsonWriter beginArray() throws IOException;

    public abstract JsonWriter endArray() throws IOException;

    public abstract JsonWriter beginObject() throws IOException;

    public abstract JsonWriter endObject() throws IOException;

    public abstract JsonWriter name(String var1) throws IOException;

    public abstract JsonWriter value(@Nullable String var1) throws IOException;

    public abstract JsonWriter nullValue() throws IOException;

    public abstract JsonWriter value(boolean var1) throws IOException;

    public abstract JsonWriter value(@Nullable Boolean var1) throws IOException;

    public abstract JsonWriter value(double var1) throws IOException;

    public abstract JsonWriter value(long var1) throws IOException;

    public abstract JsonWriter value(@Nullable Number var1) throws IOException;

    public abstract JsonWriter value(BufferedSource var1) throws IOException;

    final void promoteValueToName() throws IOException {
        int context = this.peekScope();
        if (context != 5 && context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.promoteValueToName = true;
    }

    @CheckReturnValue
    public final int beginFlatten() {
        int context = this.peekScope();
        if (context != 5 && context != 3 && context != 2 && context != 1) {
            throw new IllegalStateException("Nesting problem.");
        }
        int token = this.flattenStackSize;
        this.flattenStackSize = this.stackSize;
        return token;
    }

    public final void endFlatten(int token) {
        this.flattenStackSize = token;
    }

    @CheckReturnValue
    public final String getPath() {
        return JsonScope.getPath(this.stackSize, this.scopes, this.pathNames, this.pathIndices);
    }
}

