/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.influxdb.config;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class InfluxDBConfig
implements Serializable {
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("the influxdb server username");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("the influxdb server password");
    public static final Option<String> URL = Options.key((String)"url").stringType().noDefaultValue().withDescription("the influxdb server url");
    public static final Option<Long> CONNECT_TIMEOUT_MS = Options.key((String)"connect_timeout_ms").longType().defaultValue((Object)15000L).withDescription("the influxdb client connect timeout ms");
    public static final Option<Integer> QUERY_TIMEOUT_SEC = Options.key((String)"query_timeout_sec").intType().defaultValue((Object)3).withDescription("the influxdb client query timeout ms");
    public static final Option<String> DATABASES = Options.key((String)"database").stringType().noDefaultValue().withDescription("the influxdb server database");
    public static final Option<String> EPOCH = Options.key((String)"epoch").stringType().defaultValue((Object)"n").withDescription("the influxdb server query epoch");
    private static final String DEFAULT_FORMAT = "MSGPACK";
    private String url;
    private String username;
    private String password;
    private String database;
    private String format = "MSGPACK";
    private int queryTimeOut = (Integer)QUERY_TIMEOUT_SEC.defaultValue();
    private long connectTimeOut = (Long)CONNECT_TIMEOUT_MS.defaultValue();
    private String epoch = (String)EPOCH.defaultValue();

    public InfluxDBConfig(Config config) {
        this.url = config.getString(URL.key());
        if (config.hasPath(USERNAME.key())) {
            this.username = config.getString(USERNAME.key());
        }
        if (config.hasPath(PASSWORD.key())) {
            this.password = config.getString(PASSWORD.key());
        }
        if (config.hasPath(DATABASES.key())) {
            this.database = config.getString(DATABASES.key());
        }
        if (config.hasPath(EPOCH.key())) {
            this.epoch = config.getString(EPOCH.key());
        }
        if (config.hasPath(CONNECT_TIMEOUT_MS.key())) {
            this.connectTimeOut = config.getLong(CONNECT_TIMEOUT_MS.key());
        }
        if (config.hasPath(QUERY_TIMEOUT_SEC.key())) {
            this.queryTimeOut = config.getInt(QUERY_TIMEOUT_SEC.key());
        }
    }

    @VisibleForTesting
    public InfluxDBConfig(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getFormat() {
        return this.format;
    }

    public int getQueryTimeOut() {
        return this.queryTimeOut;
    }

    public long getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public String getEpoch() {
        return this.epoch;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setQueryTimeOut(int queryTimeOut) {
        this.queryTimeOut = queryTimeOut;
    }

    public void setConnectTimeOut(long connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public void setEpoch(String epoch) {
        this.epoch = epoch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfluxDBConfig)) {
            return false;
        }
        InfluxDBConfig other = (InfluxDBConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQueryTimeOut() != other.getQueryTimeOut()) {
            return false;
        }
        if (this.getConnectTimeOut() != other.getConnectTimeOut()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$epoch = this.getEpoch();
        String other$epoch = other.getEpoch();
        return !(this$epoch == null ? other$epoch != null : !this$epoch.equals(other$epoch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfluxDBConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQueryTimeOut();
        long $connectTimeOut = this.getConnectTimeOut();
        result = result * 59 + (int)($connectTimeOut >>> 32 ^ $connectTimeOut);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $epoch = this.getEpoch();
        result = result * 59 + ($epoch == null ? 43 : $epoch.hashCode());
        return result;
    }

    public String toString() {
        return "InfluxDBConfig(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", format=" + this.getFormat() + ", queryTimeOut=" + this.getQueryTimeOut() + ", connectTimeOut=" + this.getConnectTimeOut() + ", epoch=" + this.getEpoch() + ")";
    }
}

