/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.influxdb.config;

import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.InfluxDBConfig;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class SourceConfig
extends InfluxDBConfig {
    public static final Option<String> SQL = Options.key((String)"sql").stringType().noDefaultValue().withDescription("the influxdb server query sql");
    public static final Option<String> SQL_WHERE = Options.key((String)"where").stringType().noDefaultValue().withDescription("the influxdb server query sql where condition");
    public static final Option<String> SPLIT_COLUMN = Options.key((String)"split_column").stringType().noDefaultValue().withDescription("the influxdb column which is used as split key");
    public static final Option<String> PARTITION_NUM = Options.key((String)"partition_num").stringType().defaultValue((Object)"0").withDescription("the influxdb server partition num");
    public static final Option<String> UPPER_BOUND = Options.key((String)"upper_bound").stringType().noDefaultValue().withDescription("the influxdb server upper bound");
    public static final Option<String> LOWER_BOUND = Options.key((String)"lower_bound").stringType().noDefaultValue().withDescription("the influxdb server lower bound");
    public static final String DEFAULT_PARTITIONS = (String)PARTITION_NUM.defaultValue();
    private String sql;
    private int partitionNum = 0;
    private String splitKey;
    private long lowerBound;
    private long upperBound;
    List<Integer> columnsIndex;

    public SourceConfig(Config config) {
        super(config);
    }

    public static SourceConfig loadConfig(Config config) {
        SourceConfig sourceConfig = new SourceConfig(config);
        sourceConfig.sql = config.getString(SQL.key());
        if (config.hasPath(PARTITION_NUM.key())) {
            sourceConfig.partitionNum = config.getInt(PARTITION_NUM.key());
        }
        if (config.hasPath(UPPER_BOUND.key())) {
            sourceConfig.upperBound = config.getInt(UPPER_BOUND.key());
        }
        if (config.hasPath(LOWER_BOUND.key())) {
            sourceConfig.lowerBound = config.getInt(LOWER_BOUND.key());
        }
        if (config.hasPath(SPLIT_COLUMN.key())) {
            sourceConfig.splitKey = config.getString(SPLIT_COLUMN.key());
        }
        return sourceConfig;
    }

    public String getSql() {
        return this.sql;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public String getSplitKey() {
        return this.splitKey;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public List<Integer> getColumnsIndex() {
        return this.columnsIndex;
    }
}

