/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.influxdb.serialize;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.influxdb.exception.InfluxdbConnectorException;
import org.apache.seatunnel.connectors.seatunnel.influxdb.serialize.Serializer;
import org.influxdb.dto.Point;

public class DefaultSerializer
implements Serializer {
    private final SeaTunnelRowType seaTunnelRowType;
    private final BiConsumer<SeaTunnelRow, Point.Builder> timestampExtractor;
    private final BiConsumer<SeaTunnelRow, Point.Builder> fieldExtractor;
    private final BiConsumer<SeaTunnelRow, Point.Builder> tagExtractor;
    private final String measurement;
    private final TimeUnit precision;

    public DefaultSerializer(SeaTunnelRowType seaTunnelRowType, TimeUnit precision, List<String> tagKeys, String timestampKey, String measurement) {
        this.measurement = measurement;
        this.seaTunnelRowType = seaTunnelRowType;
        this.timestampExtractor = this.createTimestampExtractor(seaTunnelRowType, timestampKey);
        this.tagExtractor = this.createTagExtractor(seaTunnelRowType, tagKeys);
        List<String> fieldKeys = this.getFieldKeys(seaTunnelRowType, timestampKey, tagKeys);
        this.fieldExtractor = this.createFieldExtractor(seaTunnelRowType, fieldKeys);
        this.precision = precision;
    }

    @Override
    public Point serialize(SeaTunnelRow seaTunnelRow) {
        Point.Builder builder = Point.measurement(this.measurement);
        this.timestampExtractor.accept(seaTunnelRow, builder);
        this.tagExtractor.accept(seaTunnelRow, builder);
        this.fieldExtractor.accept(seaTunnelRow, builder);
        return builder.build();
    }

    private BiConsumer<SeaTunnelRow, Point.Builder> createFieldExtractor(SeaTunnelRowType seaTunnelRowType, List<String> fieldKeys) {
        return (row, builder) -> {
            block9: for (String field : fieldKeys) {
                int indexOfSeaTunnelRow = seaTunnelRowType.indexOf(field);
                SeaTunnelDataType dataType = seaTunnelRowType.getFieldType(indexOfSeaTunnelRow);
                Object val = row.getField(indexOfSeaTunnelRow);
                switch (dataType.getSqlType()) {
                    case BOOLEAN: {
                        builder.addField(field, (Boolean)val);
                        continue block9;
                    }
                    case SMALLINT: {
                        builder.addField(field, (Short)val);
                        continue block9;
                    }
                    case INT: {
                        builder.addField(field, ((Number)val).intValue());
                        continue block9;
                    }
                    case BIGINT: {
                        builder.addField(field, ((Number)val).longValue());
                        continue block9;
                    }
                    case FLOAT: {
                        builder.addField(field, ((Number)val).floatValue());
                        continue block9;
                    }
                    case DOUBLE: {
                        builder.addField(field, ((Number)val).doubleValue());
                        continue block9;
                    }
                    case STRING: {
                        builder.addField(field, val.toString());
                        continue block9;
                    }
                }
                throw new InfluxdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unsupported data type: " + dataType);
            }
        };
    }

    private BiConsumer<SeaTunnelRow, Point.Builder> createTimestampExtractor(SeaTunnelRowType seaTunnelRowType, String timeKey) {
        if (Strings.isNullOrEmpty((String)timeKey)) {
            return (row, builder) -> builder.time(System.currentTimeMillis(), this.precision);
        }
        int timeFieldIndex = seaTunnelRowType.indexOf(timeKey);
        return (row, builder) -> {
            Object time = row.getField(timeFieldIndex);
            if (time == null) {
                builder.time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            SeaTunnelDataType timestampFieldType = seaTunnelRowType.getFieldType(timeFieldIndex);
            switch (timestampFieldType.getSqlType()) {
                case STRING: {
                    builder.time(Long.parseLong((String)time), this.precision);
                    break;
                }
                case TIMESTAMP: {
                    builder.time(((LocalDateTime)time).atZone(ZoneOffset.UTC).toInstant().toEpochMilli(), this.precision);
                    break;
                }
                case BIGINT: {
                    builder.time((Long)time, this.precision);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported data type: " + timestampFieldType);
                }
            }
        };
    }

    private BiConsumer<SeaTunnelRow, Point.Builder> createTagExtractor(SeaTunnelRowType seaTunnelRowType, List<String> tagKeys) {
        if (CollectionUtils.isEmpty(tagKeys)) {
            return (row, builder) -> {};
        }
        return (row, builder) -> {
            for (String tagKey : tagKeys) {
                int indexOfSeaTunnelRow = seaTunnelRowType.indexOf(tagKey);
                builder.tag(tagKey, row.getField(indexOfSeaTunnelRow).toString());
            }
        };
    }

    private List<String> getFieldKeys(SeaTunnelRowType seaTunnelRowType, String timestampKey, List<String> tagKeys) {
        return Stream.of(seaTunnelRowType.getFieldNames()).filter(name -> CollectionUtils.isEmpty((Collection)tagKeys) || !tagKeys.contains(name)).filter(name -> StringUtils.isEmpty((CharSequence)timestampKey) || !name.equals(timestampKey)).collect(Collectors.toList());
    }
}

