/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.serialize;

import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.iotdb.exception.IotdbConnectorException;
import org.apache.seatunnel.connectors.seatunnel.iotdb.serialize.SeaTunnelRowDeserializer;

public class DefaultSeaTunnelRowDeserializer
implements SeaTunnelRowDeserializer {
    private final SeaTunnelRowType rowType;

    @Override
    public SeaTunnelRow deserialize(RowRecord rowRecord) {
        return this.convert(rowRecord);
    }

    private SeaTunnelRow convert(RowRecord rowRecord) {
        long timestamp = rowRecord.getTimestamp();
        List<Field> fields = rowRecord.getFields();
        if (fields.size() != this.rowType.getTotalFields() - 1) {
            throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Illegal SeaTunnelRowType: " + rowRecord);
        }
        Object[] seaTunnelFields = new Object[this.rowType.getTotalFields()];
        seaTunnelFields[0] = this.convertTimestamp(timestamp, this.rowType.getFieldType(0));
        for (int i = 1; i < this.rowType.getTotalFields(); ++i) {
            Field field = fields.get(i - 1);
            if (field == null || field.getDataType() == null) {
                seaTunnelFields[i] = null;
                continue;
            }
            SeaTunnelDataType seaTunnelFieldType = this.rowType.getFieldType(i);
            seaTunnelFields[i] = this.convert(seaTunnelFieldType, field);
        }
        return new SeaTunnelRow(seaTunnelFields);
    }

    private Object convert(SeaTunnelDataType<?> seaTunnelFieldType, Field field) {
        switch (field.getDataType()) {
            case INT32: {
                Integer int32 = field.getIntV();
                switch (seaTunnelFieldType.getSqlType()) {
                    case TINYINT: {
                        return ((Number)int32).byteValue();
                    }
                    case SMALLINT: {
                        return ((Number)int32).shortValue();
                    }
                    case INT: {
                        return (int)int32;
                    }
                }
                throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unsupported data type: " + seaTunnelFieldType);
            }
            case INT64: {
                return field.getLongV();
            }
            case FLOAT: {
                return Float.valueOf(field.getFloatV());
            }
            case DOUBLE: {
                return field.getDoubleV();
            }
            case TEXT: {
                return field.getStringValue();
            }
            case BOOLEAN: {
                return field.getBoolV();
            }
        }
        throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unsupported data type: " + (Object)((Object)field.getDataType()));
    }

    private Object convertTimestamp(long timestamp, SeaTunnelDataType<?> seaTunnelFieldType) {
        switch (seaTunnelFieldType.getSqlType()) {
            case TIMESTAMP: {
                return new Date(timestamp).toInstant().atZone(ZoneOffset.UTC).toLocalDateTime();
            }
            case BIGINT: {
                return timestamp;
            }
        }
        throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unsupported data type: " + seaTunnelFieldType);
    }

    public DefaultSeaTunnelRowDeserializer(SeaTunnelRowType rowType) {
        this.rowType = rowType;
    }
}

