/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.serialize;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.iotdb.exception.IotdbConnectorException;
import org.apache.seatunnel.connectors.seatunnel.iotdb.serialize.IoTDBRecord;
import org.apache.seatunnel.connectors.seatunnel.iotdb.serialize.SeaTunnelRowSerializer;
import org.apache.seatunnel.shade.com.google.common.base.Strings;

public class DefaultSeaTunnelRowSerializer
implements SeaTunnelRowSerializer {
    private final Function<SeaTunnelRow, Long> timestampExtractor;
    private final Function<SeaTunnelRow, String> deviceExtractor;
    private final Function<SeaTunnelRow, List<Object>> valuesExtractor;
    private final List<String> measurements;
    private final List<TSDataType> measurementsType;

    public DefaultSeaTunnelRowSerializer(@NonNull SeaTunnelRowType seaTunnelRowType, String storageGroup, String timestampKey, @NonNull String deviceKey, List<String> measurementKeys) {
        if (seaTunnelRowType == null) {
            throw new NullPointerException("seaTunnelRowType is marked non-null but is null");
        }
        if (deviceKey == null) {
            throw new NullPointerException("deviceKey is marked non-null but is null");
        }
        this.timestampExtractor = this.createTimestampExtractor(seaTunnelRowType, timestampKey);
        this.deviceExtractor = this.createDeviceExtractor(seaTunnelRowType, deviceKey, storageGroup);
        this.measurements = this.createMeasurements(seaTunnelRowType, timestampKey, deviceKey, measurementKeys);
        this.measurementsType = this.createMeasurementTypes(seaTunnelRowType, this.measurements);
        this.valuesExtractor = this.createValuesExtractor(seaTunnelRowType, this.measurements, this.measurementsType);
    }

    @Override
    public IoTDBRecord serialize(SeaTunnelRow seaTunnelRow) {
        Long timestamp = this.timestampExtractor.apply(seaTunnelRow);
        String device = this.deviceExtractor.apply(seaTunnelRow);
        List<Object> values = this.valuesExtractor.apply(seaTunnelRow);
        return new IoTDBRecord(device, timestamp, this.measurements, this.measurementsType, values);
    }

    private Function<SeaTunnelRow, Long> createTimestampExtractor(SeaTunnelRowType seaTunnelRowType, String timestampKey) {
        if (Strings.isNullOrEmpty((String)timestampKey)) {
            return row -> System.currentTimeMillis();
        }
        int timestampFieldIndex = seaTunnelRowType.indexOf(timestampKey);
        return row -> {
            Object timestamp = row.getField(timestampFieldIndex);
            if (timestamp == null) {
                return System.currentTimeMillis();
            }
            SeaTunnelDataType timestampFieldType = seaTunnelRowType.getFieldType(timestampFieldIndex);
            switch (timestampFieldType.getSqlType()) {
                case STRING: {
                    return Long.parseLong((String)timestamp);
                }
                case TIMESTAMP: {
                    return ((LocalDateTime)timestamp).atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
                }
                case BIGINT: {
                    return (Long)timestamp;
                }
            }
            throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unsupported data type: " + timestampFieldType);
        };
    }

    private Function<SeaTunnelRow, String> createDeviceExtractor(SeaTunnelRowType seaTunnelRowType, String deviceKey, String storageGroup) {
        int deviceIndex = seaTunnelRowType.indexOf(deviceKey);
        return seaTunnelRow -> {
            String device = seaTunnelRow.getField(deviceIndex).toString();
            if (Strings.isNullOrEmpty((String)storageGroup)) {
                return device;
            }
            if (storageGroup.endsWith(".") || device.startsWith(".")) {
                return storageGroup + device;
            }
            return storageGroup + "." + device;
        };
    }

    private List<String> createMeasurements(SeaTunnelRowType seaTunnelRowType, String timestampKey, String deviceKey, List<String> measurementKeys) {
        if (measurementKeys == null || measurementKeys.isEmpty()) {
            return Stream.of(seaTunnelRowType.getFieldNames()).filter(name -> !name.equals(deviceKey)).filter(name -> !name.equals(timestampKey)).collect(Collectors.toList());
        }
        return measurementKeys;
    }

    private List<TSDataType> createMeasurementTypes(SeaTunnelRowType seaTunnelRowType, List<String> measurements) {
        return measurements.stream().map(measurement -> {
            int indexOfSeaTunnelRow = seaTunnelRowType.indexOf(measurement);
            SeaTunnelDataType seaTunnelType = seaTunnelRowType.getFieldType(indexOfSeaTunnelRow);
            return DefaultSeaTunnelRowSerializer.convert(seaTunnelType);
        }).collect(Collectors.toList());
    }

    private Function<SeaTunnelRow, List<Object>> createValuesExtractor(SeaTunnelRowType seaTunnelRowType, List<String> measurements, List<TSDataType> measurementTypes) {
        return row -> {
            ArrayList<Object> measurementValues = new ArrayList<Object>(measurements.size());
            for (int i = 0; i < measurements.size(); ++i) {
                String measurement = (String)measurements.get(i);
                TSDataType measurementDataType = this.measurementsType.get(i);
                int indexOfSeaTunnelRow = seaTunnelRowType.indexOf(measurement);
                SeaTunnelDataType seaTunnelDataType = seaTunnelRowType.getFieldType(indexOfSeaTunnelRow);
                Object seaTunnelFieldValue = row.getField(indexOfSeaTunnelRow);
                Object measurementValue = DefaultSeaTunnelRowSerializer.convert(seaTunnelDataType, measurementDataType, seaTunnelFieldValue);
                measurementValues.add(measurementValue);
            }
            return measurementValues;
        };
    }

    private static TSDataType convert(SeaTunnelDataType dataType) {
        switch (dataType.getSqlType()) {
            case STRING: {
                return TSDataType.TEXT;
            }
            case BOOLEAN: {
                return TSDataType.BOOLEAN;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                return TSDataType.INT32;
            }
            case BIGINT: {
                return TSDataType.INT64;
            }
            case FLOAT: {
                return TSDataType.FLOAT;
            }
            case DOUBLE: {
                return TSDataType.DOUBLE;
            }
        }
        throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unsupported data type: " + dataType);
    }

    private static Object convert(SeaTunnelDataType seaTunnelType, TSDataType tsDataType, Object value) {
        if (value == null) {
            return null;
        }
        switch (tsDataType) {
            case INT32: {
                return ((Number)value).intValue();
            }
            case INT64: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)value).floatValue());
            }
            case DOUBLE: {
                return ((Number)value).doubleValue();
            }
            case BOOLEAN: {
                return (boolean)((Boolean)value);
            }
            case TEXT: {
                return value.toString();
            }
        }
        throw new IotdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unsupported data type: " + (Object)((Object)tsDataType));
    }
}

