/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.config;

import com.google.common.base.Preconditions;
import java.time.ZoneId;
import java.util.List;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.seatunnel.iotdb.config.CommonConfig;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class SinkConfig
extends CommonConfig {
    private static final int DEFAULT_BATCH_SIZE = 1024;
    public static final Option<String> KEY_TIMESTAMP = Options.key((String)"key_timestamp").stringType().noDefaultValue().withDescription("key timestamp");
    public static final Option<String> KEY_DEVICE = Options.key((String)"key_device").stringType().noDefaultValue().withDescription("key device");
    public static final Option<List<String>> KEY_MEASUREMENT_FIELDS = Options.key((String)"key_measurement_fields").listType().noDefaultValue().withDescription("key measurement fields");
    public static final Option<String> STORAGE_GROUP = Options.key((String)"storage_group").stringType().noDefaultValue().withDescription("store group");
    public static final Option<Integer> BATCH_SIZE = Options.key((String)"batch_size").intType().defaultValue((Object)1024).withDescription("batch size");
    public static final Option<String> BATCH_INTERVAL_MS = Options.key((String)"batch_interval_ms").stringType().noDefaultValue().withDescription("batch interval ms");
    public static final Option<Integer> MAX_RETRIES = Options.key((String)"max_retries").intType().noDefaultValue().withDescription("max retries");
    public static final Option<Integer> RETRY_BACKOFF_MULTIPLIER_MS = Options.key((String)"retry_backoff_multiplier_ms").intType().noDefaultValue().withDescription("retry backoff multiplier ms ");
    public static final Option<Integer> MAX_RETRY_BACKOFF_MS = Options.key((String)"max_retry_backoff_ms").intType().noDefaultValue().withDescription("max retry backoff ms ");
    public static final Option<Integer> DEFAULT_THRIFT_BUFFER_SIZE = Options.key((String)"default_thrift_buffer_size").intType().noDefaultValue().withDescription("default thrift buffer size");
    public static final Option<Integer> MAX_THRIFT_FRAME_SIZE = Options.key((String)"max_thrift_frame_size").intType().noDefaultValue().withDescription("max thrift frame size");
    public static final Option<String> ZONE_ID = Options.key((String)"zone_id").stringType().noDefaultValue().withDescription("zone id");
    public static final Option<Boolean> ENABLE_RPC_COMPRESSION = Options.key((String)"enable_rpc_compression").booleanType().noDefaultValue().withDescription("enable rpc comm");
    public static final Option<Integer> CONNECTION_TIMEOUT_IN_MS = Options.key((String)"connection_timeout_in_ms").intType().noDefaultValue().withDescription("connection timeout ms");
    private String keyTimestamp;
    private String keyDevice;
    private List<String> keyMeasurementFields;
    private String storageGroup;
    private int batchSize = (Integer)BATCH_SIZE.defaultValue();
    private Integer batchIntervalMs;
    private int maxRetries;
    private int retryBackoffMultiplierMs;
    private int maxRetryBackoffMs;
    private Integer thriftDefaultBufferSize;
    private Integer thriftMaxFrameSize;
    private ZoneId zoneId;
    private Boolean enableRPCCompression;
    private Integer connectionTimeoutInMs;

    public SinkConfig(@NonNull List<String> nodeUrls, @NonNull String username, @NonNull String password) {
        super(nodeUrls, username, password);
        if (nodeUrls == null) {
            throw new NullPointerException("nodeUrls is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
    }

    public static SinkConfig loadConfig(Config pluginConfig) {
        SinkConfig sinkConfig = new SinkConfig(pluginConfig.getStringList(NODE_URLS.key()), pluginConfig.getString(USERNAME.key()), pluginConfig.getString(PASSWORD.key()));
        sinkConfig.setKeyDevice(pluginConfig.getString(KEY_DEVICE.key()));
        if (pluginConfig.hasPath(KEY_TIMESTAMP.key())) {
            sinkConfig.setKeyTimestamp(pluginConfig.getString(KEY_TIMESTAMP.key()));
        }
        if (pluginConfig.hasPath(KEY_MEASUREMENT_FIELDS.key())) {
            sinkConfig.setKeyMeasurementFields(pluginConfig.getStringList(KEY_MEASUREMENT_FIELDS.key()));
        }
        if (pluginConfig.hasPath(STORAGE_GROUP.key())) {
            sinkConfig.setStorageGroup(pluginConfig.getString(STORAGE_GROUP.key()));
        }
        if (pluginConfig.hasPath(BATCH_SIZE.key())) {
            int batchSize = SinkConfig.checkIntArgument(pluginConfig.getInt(BATCH_SIZE.key()));
            sinkConfig.setBatchSize(batchSize);
        }
        if (pluginConfig.hasPath(BATCH_INTERVAL_MS.key())) {
            int batchIntervalMs = SinkConfig.checkIntArgument(pluginConfig.getInt(BATCH_INTERVAL_MS.key()));
            sinkConfig.setBatchIntervalMs(batchIntervalMs);
        }
        if (pluginConfig.hasPath(MAX_RETRIES.key())) {
            int maxRetries = SinkConfig.checkIntArgument(pluginConfig.getInt(MAX_RETRIES.key()));
            sinkConfig.setMaxRetries(maxRetries);
        }
        if (pluginConfig.hasPath(RETRY_BACKOFF_MULTIPLIER_MS.key())) {
            int retryBackoffMultiplierMs = SinkConfig.checkIntArgument(pluginConfig.getInt(RETRY_BACKOFF_MULTIPLIER_MS.key()));
            sinkConfig.setRetryBackoffMultiplierMs(retryBackoffMultiplierMs);
        }
        if (pluginConfig.hasPath(MAX_RETRY_BACKOFF_MS.key())) {
            int maxRetryBackoffMs = SinkConfig.checkIntArgument(pluginConfig.getInt(MAX_RETRY_BACKOFF_MS.key()));
            sinkConfig.setMaxRetryBackoffMs(maxRetryBackoffMs);
        }
        if (pluginConfig.hasPath(DEFAULT_THRIFT_BUFFER_SIZE.key())) {
            int thriftDefaultBufferSize = SinkConfig.checkIntArgument(pluginConfig.getInt(DEFAULT_THRIFT_BUFFER_SIZE.key()));
            sinkConfig.setThriftDefaultBufferSize(thriftDefaultBufferSize);
        }
        if (pluginConfig.hasPath(MAX_THRIFT_FRAME_SIZE.key())) {
            int thriftMaxFrameSize = SinkConfig.checkIntArgument(pluginConfig.getInt(MAX_THRIFT_FRAME_SIZE.key()));
            sinkConfig.setThriftMaxFrameSize(thriftMaxFrameSize);
        }
        if (pluginConfig.hasPath(ZONE_ID.key())) {
            sinkConfig.setZoneId(ZoneId.of(pluginConfig.getString(ZONE_ID.key())));
        }
        if (pluginConfig.hasPath(ENABLE_RPC_COMPRESSION.key())) {
            sinkConfig.setEnableRPCCompression(pluginConfig.getBoolean(ENABLE_RPC_COMPRESSION.key()));
        }
        if (pluginConfig.hasPath(CONNECTION_TIMEOUT_IN_MS.key())) {
            int connectionTimeoutInMs = SinkConfig.checkIntArgument(pluginConfig.getInt(CONNECTION_TIMEOUT_IN_MS.key()));
            Preconditions.checkNotNull((Object)sinkConfig.getEnableRPCCompression());
            sinkConfig.setConnectionTimeoutInMs(connectionTimeoutInMs);
        }
        return sinkConfig;
    }

    private static int checkIntArgument(int args) {
        Preconditions.checkArgument((args > 0 ? 1 : 0) != 0);
        return args;
    }

    public void setKeyTimestamp(String keyTimestamp) {
        this.keyTimestamp = keyTimestamp;
    }

    public void setKeyDevice(String keyDevice) {
        this.keyDevice = keyDevice;
    }

    public void setKeyMeasurementFields(List<String> keyMeasurementFields) {
        this.keyMeasurementFields = keyMeasurementFields;
    }

    public void setStorageGroup(String storageGroup) {
        this.storageGroup = storageGroup;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchIntervalMs(Integer batchIntervalMs) {
        this.batchIntervalMs = batchIntervalMs;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetryBackoffMultiplierMs(int retryBackoffMultiplierMs) {
        this.retryBackoffMultiplierMs = retryBackoffMultiplierMs;
    }

    public void setMaxRetryBackoffMs(int maxRetryBackoffMs) {
        this.maxRetryBackoffMs = maxRetryBackoffMs;
    }

    public void setThriftDefaultBufferSize(Integer thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
    }

    public void setThriftMaxFrameSize(Integer thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setEnableRPCCompression(Boolean enableRPCCompression) {
        this.enableRPCCompression = enableRPCCompression;
    }

    public void setConnectionTimeoutInMs(Integer connectionTimeoutInMs) {
        this.connectionTimeoutInMs = connectionTimeoutInMs;
    }

    public String getKeyTimestamp() {
        return this.keyTimestamp;
    }

    public String getKeyDevice() {
        return this.keyDevice;
    }

    public List<String> getKeyMeasurementFields() {
        return this.keyMeasurementFields;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Integer getBatchIntervalMs() {
        return this.batchIntervalMs;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryBackoffMultiplierMs() {
        return this.retryBackoffMultiplierMs;
    }

    public int getMaxRetryBackoffMs() {
        return this.maxRetryBackoffMs;
    }

    public Integer getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public Integer getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public Boolean getEnableRPCCompression() {
        return this.enableRPCCompression;
    }

    public Integer getConnectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    @Override
    public String toString() {
        return "SinkConfig(keyTimestamp=" + this.getKeyTimestamp() + ", keyDevice=" + this.getKeyDevice() + ", keyMeasurementFields=" + this.getKeyMeasurementFields() + ", storageGroup=" + this.getStorageGroup() + ", batchSize=" + this.getBatchSize() + ", batchIntervalMs=" + this.getBatchIntervalMs() + ", maxRetries=" + this.getMaxRetries() + ", retryBackoffMultiplierMs=" + this.getRetryBackoffMultiplierMs() + ", maxRetryBackoffMs=" + this.getMaxRetryBackoffMs() + ", thriftDefaultBufferSize=" + this.getThriftDefaultBufferSize() + ", thriftMaxFrameSize=" + this.getThriftMaxFrameSize() + ", zoneId=" + this.getZoneId() + ", enableRPCCompression=" + this.getEnableRPCCompression() + ", connectionTimeoutInMs=" + this.getConnectionTimeoutInMs() + ")";
    }
}

