/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.sink;

import java.io.IOException;
import java.util.Optional;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.iotdb.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.iotdb.serialize.DefaultSeaTunnelRowSerializer;
import org.apache.seatunnel.connectors.seatunnel.iotdb.serialize.IoTDBRecord;
import org.apache.seatunnel.connectors.seatunnel.iotdb.serialize.SeaTunnelRowSerializer;
import org.apache.seatunnel.connectors.seatunnel.iotdb.sink.IoTDBSinkClient;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private static final Logger log = LoggerFactory.getLogger(IoTDBSinkWriter.class);
    private final SeaTunnelRowSerializer serializer;
    private final IoTDBSinkClient sinkClient;

    public IoTDBSinkWriter(Config pluginConfig, SeaTunnelRowType seaTunnelRowType) {
        SinkConfig sinkConfig = SinkConfig.loadConfig(pluginConfig);
        this.serializer = new DefaultSeaTunnelRowSerializer(seaTunnelRowType, sinkConfig.getStorageGroup(), sinkConfig.getKeyTimestamp(), sinkConfig.getKeyDevice(), sinkConfig.getKeyMeasurementFields());
        this.sinkClient = new IoTDBSinkClient(sinkConfig);
    }

    public void write(SeaTunnelRow element) throws IOException {
        IoTDBRecord record = this.serializer.serialize(element);
        this.sinkClient.write(record);
    }

    @Override
    public Optional<Void> prepareCommit() {
        this.sinkClient.flush();
        return super.prepareCommit();
    }

    public void close() throws IOException {
        this.sinkClient.close();
    }
}

