/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle;

import java.io.ByteArrayInputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.AbstractJdbcRowConverter;

public class OracleJdbcRowConverter
extends AbstractJdbcRowConverter {
    @Override
    public String converterName() {
        return "Oracle";
    }

    @Override
    protected void setValueToStatementByDataType(Object value, PreparedStatement statement, SeaTunnelDataType<?> seaTunnelDataType, int statementIndex, @Nullable String sourceType) throws SQLException {
        if (seaTunnelDataType.getSqlType().equals((Object)SqlType.BYTES)) {
            if ("BLOB".equals(sourceType)) {
                statement.setBinaryStream(statementIndex, new ByteArrayInputStream((byte[])value));
            } else {
                statement.setBytes(statementIndex, (byte[])value);
            }
        } else {
            super.setValueToStatementByDataType(value, statement, seaTunnelDataType, statementIndex, sourceType);
        }
    }
}

