/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql;

import com.mysql.cj.MysqlType;
import com.mysql.cj.util.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql.MysqlCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql.MysqlDataTypeConvertor;

public class MySqlCatalog
extends AbstractJdbcCatalog {
    protected static final Set<String> SYS_DATABASES = new HashSet<String>(4);
    protected final Map<String, Connection> connectionMap = new ConcurrentHashMap<String, Connection>();

    public MySqlCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo) {
        super(catalogName, username, pwd, urlInfo);
    }

    public Connection getConnection(String url) {
        if (this.connectionMap.containsKey(url)) {
            return this.connectionMap.get(url);
        }
        try {
            Connection connection = DriverManager.getConnection(url, this.username, this.pwd);
            this.connectionMap.put(url, connection);
            return connection;
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed connecting to %s via JDBC.", url), (Throwable)e);
        }
    }

    @Override
    public void close() throws CatalogException {
        for (Map.Entry<String, Connection> entry : this.connectionMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (SQLException e) {
                throw new CatalogException(String.format("Failed to close %s via JDBC.", entry.getKey()), (Throwable)e);
            }
        }
        super.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listDatabases() throws CatalogException {
        try (PreparedStatement ps = this.defaultConnection.prepareStatement("SHOW DATABASES;");){
            ArrayList<String> databases = new ArrayList<String>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String databaseName = rs.getString(1);
                if (SYS_DATABASES.contains(databaseName)) continue;
                databases.add(rs.getString(1));
            }
            ArrayList<String> arrayList = databases;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        String dbUrl = this.getUrlFromDatabaseName(databaseName);
        try (PreparedStatement ps = this.getConnection(dbUrl).prepareStatement("SHOW TABLES;");){
            ResultSet rs = ps.executeQuery();
            ArrayList<String> tables = new ArrayList<String>();
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
            ArrayList<String> arrayList = tables;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
        Connection conn = this.getConnection(dbUrl);
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            Optional<PrimaryKey> primaryKey = this.getPrimaryKey(metaData, tablePath.getDatabaseName(), tablePath.getTableName());
            List<ConstraintKey> constraintKeys = this.getConstraintKeys(metaData, tablePath.getDatabaseName(), tablePath.getTableName());
            Map<String, Object> columnsDefaultValue = MySqlCatalog.getColumnsDefaultValue(tablePath, conn);
            try (PreparedStatement ps = conn.prepareStatement(String.format("SELECT * FROM %s WHERE 1 = 0;", tablePath.getFullNameWithQuoted()));){
                ResultSetMetaData tableMetaData = ps.getMetaData();
                TableSchema.Builder builder = TableSchema.builder();
                for (int i = 1; i <= tableMetaData.getColumnCount(); ++i) {
                    String columnName = tableMetaData.getColumnName(i);
                    SeaTunnelDataType<?> type = this.fromJdbcType(tableMetaData, i);
                    int columnDisplaySize = tableMetaData.getColumnDisplaySize(i);
                    String comment = tableMetaData.getColumnLabel(i);
                    boolean isNullable = tableMetaData.isNullable(i) == 1;
                    Object defaultValue = columnsDefaultValue.get(columnName);
                    PhysicalColumn physicalColumn = PhysicalColumn.of((String)columnName, type, (Integer)columnDisplaySize, (boolean)isNullable, (Object)defaultValue, (String)comment);
                    builder.column((Column)physicalColumn);
                }
                primaryKey.ifPresent(arg_0 -> ((TableSchema.Builder)builder).primaryKey(arg_0));
                constraintKeys.forEach(arg_0 -> ((TableSchema.Builder)builder).constraintKey(arg_0));
                TableIdentifier tableIdentifier = TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName());
                CatalogTable catalogTable = CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)builder.build(), this.buildConnectorOptions(tablePath), Collections.emptyList(), (String)"");
                return catalogTable;
            }
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> getColumnsDefaultValue(TablePath tablePath, Connection conn) {
        StringBuilder queryBuf = new StringBuilder("SHOW FULL COLUMNS FROM ");
        queryBuf.append(StringUtils.quoteIdentifier((String)tablePath.getTableName(), (String)"`", (boolean)false));
        queryBuf.append(" FROM ");
        queryBuf.append(StringUtils.quoteIdentifier((String)tablePath.getDatabaseName(), (String)"`", (boolean)false));
        try (PreparedStatement ps2 = conn.prepareStatement(queryBuf.toString());){
            ResultSet rs = ps2.executeQuery();
            HashMap<String, Object> result = new HashMap<String, Object>();
            while (rs.next()) {
                String field = rs.getString("Field");
                Object defaultValue = rs.getObject("Default");
                result.put(field, defaultValue);
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table(%s) columns default value", tablePath.getFullName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean createTableInternal(TablePath tablePath, CatalogTable table) throws CatalogException {
        String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
        String createTableSql = MysqlCreateTableSqlBuilder.builder(tablePath, table).build();
        try (PreparedStatement ps = this.getConnection(dbUrl).prepareStatement(createTableSql);){
            boolean bl = ps.execute();
            return bl;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed creating table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean dropTableInternal(TablePath tablePath) throws CatalogException {
        String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
        try (PreparedStatement ps = this.getConnection(dbUrl).prepareStatement(String.format("DROP TABLE %s IF EXIST;", tablePath.getFullName()));){
            boolean bl = ps.execute();
            return bl;
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed dropping table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean createDatabaseInternal(String databaseName) throws CatalogException {
        try (PreparedStatement ps = this.defaultConnection.prepareStatement(String.format("CREATE DATABASE `%s`;", databaseName));){
            boolean bl = ps.execute();
            return bl;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed creating database %s in catalog %s", databaseName, this.catalogName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean dropDatabaseInternal(String databaseName) throws CatalogException {
        try (PreparedStatement ps = this.defaultConnection.prepareStatement(String.format("DROP DATABASE `%s`;", databaseName));){
            boolean bl = ps.execute();
            return bl;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed dropping database %s in catalog %s", databaseName, this.catalogName), (Throwable)e);
        }
    }

    private SeaTunnelDataType<?> fromJdbcType(ResultSetMetaData metadata, int colIndex) throws SQLException {
        MysqlType mysqlType = MysqlType.getByName((String)metadata.getColumnTypeName(colIndex));
        HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
        dataTypeProperties.put("precision", metadata.getPrecision(colIndex));
        dataTypeProperties.put("scale", metadata.getScale(colIndex));
        return new MysqlDataTypeConvertor().toSeaTunnelType(mysqlType, dataTypeProperties);
    }

    private Map<String, String> buildConnectorOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>(8);
        options.put("connector", "jdbc");
        options.put("url", this.baseUrl + tablePath.getDatabaseName());
        options.put("table-name", tablePath.getFullName());
        options.put("username", this.username);
        options.put("password", this.pwd);
        return options;
    }

    private String getUrlFromDatabaseName(String databaseName) {
        return this.baseUrl + databaseName + this.suffix;
    }

    static {
        SYS_DATABASES.add("information_schema");
        SYS_DATABASES.add("mysql");
        SYS_DATABASES.add("performance_schema");
        SYS_DATABASES.add("sys");
    }
}

