/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import microsoft.sql.DateTimeOffset;
import org.apache.commons.lang3.tuple.Pair;

public enum SqlServerType implements SQLType
{
    UNKNOWN("unknown", 999, Object.class),
    TINYINT("tinyint", -6, Short.class),
    BIT("bit", -7, Boolean.class),
    SMALLINT("smallint", 5, Short.class),
    INTEGER("int", 4, Integer.class),
    BIGINT("bigint", -5, Long.class),
    FLOAT("float", 8, Double.class),
    REAL("real", 7, Float.class),
    SMALLDATETIME("smalldatetime", -150, Timestamp.class),
    DATETIME("datetime", -151, Timestamp.class),
    DATE("date", 91, Date.class),
    TIME("time", 92, Time.class),
    DATETIME2("datetime2", 93, Timestamp.class),
    DATETIMEOFFSET("datetimeoffset", -155, DateTimeOffset.class),
    SMALLMONEY("smallmoney", -146, BigDecimal.class),
    MONEY("money", -148, BigDecimal.class),
    CHAR("char", 1, String.class),
    VARCHAR("varchar", 12, String.class),
    VARCHARMAX("varchar", -1, String.class),
    TEXT("text", -1, String.class),
    NCHAR("nchar", -15, String.class),
    NVARCHAR("nvarchar", -9, String.class),
    NVARCHARMAX("nvarchar", -16, String.class),
    NTEXT("ntext", -16, String.class),
    BINARY("binary", -2, byte[].class),
    VARBINARY("varbinary", -3, byte[].class),
    VARBINARYMAX("varbinary", -4, byte[].class),
    IMAGE("image", -4, byte[].class),
    DECIMAL("decimal", 3, BigDecimal.class, true, true),
    NUMERIC("numeric", 2, BigDecimal.class),
    GUID("uniqueidentifier", -145, String.class),
    SQL_VARIANT("sql_variant", -156, Object.class),
    UDT("udt", -3, byte[].class),
    XML("xml", -16, String.class),
    TIMESTAMP("timestamp", -2, byte[].class),
    GEOMETRY("geometry", -157, Object.class),
    GEOGRAPHY("geography", -157, Object.class);

    private static final String PRECISION = "precision";
    private static final String SCALE = "scale";
    private static final String LENGTH = "length";
    private final String name;
    private final int jdbcType;
    private final Class<?> javaClass;
    private final boolean isDecimal;
    private final boolean hasLength;

    private SqlServerType(String sqlServerTypeName, int jdbcType, Class<?> javaClass) {
        this(sqlServerTypeName, jdbcType, javaClass, false, false);
    }

    private SqlServerType(String sqlServerTypeName, int jdbcType, Class<?> javaClass, boolean isDec, boolean hasLength) {
        this.name = sqlServerTypeName;
        this.jdbcType = jdbcType;
        this.javaClass = javaClass;
        this.isDecimal = isDec;
        this.hasLength = hasLength;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVendor() {
        return "com.microsoft.sqlserver.jdbc";
    }

    @Override
    public Integer getVendorTypeNumber() {
        return this.jdbcType;
    }

    public String getSqlTypeName(Map<String, Object> params) {
        if (this.isDecimal) {
            Object precision = params.get(PRECISION);
            Object scale = params.get(SCALE);
            return String.format("%s(%s, %s)", this.getName(), precision, scale);
        }
        if (this.hasLength) {
            Object length = params.get(LENGTH);
            return String.format("%s(%s)", this.getName(), length);
        }
        return this.getName();
    }

    public String getSqlTypeName() {
        return this.getSqlTypeName(Collections.emptyMap());
    }

    public String getSqlTypeName(long length) {
        return this.getSqlTypeName(Collections.singletonMap(LENGTH, length));
    }

    public String getSqlTypeName(long precision, long scale) {
        return this.getSqlTypeName((Map<String, Object>)ImmutableMap.of((Object)PRECISION, (Object)precision, (Object)SCALE, (Object)scale));
    }

    public static Pair<SqlServerType, Map<String, Object>> parse(String fullTypeName) {
        HashMap<String, String> params = new HashMap<String, String>();
        String typeName = fullTypeName;
        if (fullTypeName.indexOf("(") != -1) {
            typeName = fullTypeName.substring(0, fullTypeName.indexOf("(")).trim();
            String paramsStr = fullTypeName.substring(fullTypeName.indexOf("(") + 1, fullTypeName.indexOf(")"));
            if (DECIMAL.getName().equalsIgnoreCase(typeName)) {
                String[] precisionAndScale = paramsStr.split(",");
                params.put(PRECISION, precisionAndScale[0].trim());
                params.put(SCALE, precisionAndScale[1].trim());
            } else {
                params.put(LENGTH, paramsStr.trim());
            }
        }
        SqlServerType sqlServerType = null;
        for (SqlServerType type : SqlServerType.values()) {
            if (!type.getName().equalsIgnoreCase(typeName)) continue;
            sqlServerType = type;
            break;
        }
        Objects.requireNonNull(sqlServerType);
        return Pair.of(sqlServerType, params);
    }
}

