/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcCatalog
implements Catalog {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJdbcCatalog.class);
    protected final String catalogName;
    protected final String defaultDatabase;
    protected final String username;
    protected final String pwd;
    protected final String baseUrl;
    protected final String suffix;
    protected final String defaultUrl;
    protected final Optional<String> defaultSchema;
    protected Connection defaultConnection;

    public AbstractJdbcCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo, String defaultSchema) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)username));
        urlInfo.getDefaultDatabase().orElseThrow(() -> new IllegalArgumentException("Can't find default database in url"));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)urlInfo.getUrlWithoutDatabase()));
        this.catalogName = catalogName;
        this.defaultDatabase = (String)urlInfo.getDefaultDatabase().get();
        this.username = username;
        this.pwd = pwd;
        this.baseUrl = urlInfo.getUrlWithoutDatabase();
        this.defaultUrl = urlInfo.getOrigin();
        this.suffix = urlInfo.getSuffix();
        this.defaultSchema = Optional.ofNullable(defaultSchema);
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.pwd;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void open() throws CatalogException {
        try {
            this.defaultConnection = DriverManager.getConnection(this.defaultUrl, this.username, this.pwd);
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed connecting to %s via JDBC.", this.defaultUrl), (Throwable)e);
        }
        LOG.info("Catalog {} established connection to {}", (Object)this.catalogName, (Object)this.defaultUrl);
    }

    public void close() throws CatalogException {
        if (this.defaultConnection == null) {
            return;
        }
        try {
            this.defaultConnection.close();
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed to close %s via JDBC.", this.defaultUrl), (Throwable)e);
        }
        LOG.info("Catalog {} closing", (Object)this.catalogName);
    }

    protected Optional<PrimaryKey> getPrimaryKey(DatabaseMetaData metaData, String database, String table) throws SQLException {
        return this.getPrimaryKey(metaData, database, table, table);
    }

    protected Optional<PrimaryKey> getPrimaryKey(DatabaseMetaData metaData, String database, String schema, String table) throws SQLException {
        ResultSet rs = metaData.getPrimaryKeys(database, schema, table);
        ArrayList<Pair> primaryKeyColumns = new ArrayList<Pair>();
        String pkName = null;
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            pkName = rs.getString("PK_NAME");
            int keySeq = rs.getInt("KEY_SEQ");
            primaryKeyColumns.add(Pair.of((Object)keySeq, (Object)columnName));
        }
        List pkFields = primaryKeyColumns.stream().sorted(Comparator.comparingInt(Pair::getKey)).map(Pair::getValue).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pkFields)) {
            return Optional.empty();
        }
        return Optional.of(PrimaryKey.of((String)pkName, pkFields));
    }

    protected List<ConstraintKey> getConstraintKeys(DatabaseMetaData metaData, String database, String table) throws SQLException {
        return this.getConstraintKeys(metaData, database, table, table);
    }

    protected List<ConstraintKey> getConstraintKeys(DatabaseMetaData metaData, String database, String schema, String table) throws SQLException {
        ResultSet resultSet = metaData.getIndexInfo(database, schema, table, false, false);
        HashMap<String, ConstraintKey> constraintKeyMap = new HashMap<String, ConstraintKey>();
        while (resultSet.next()) {
            String columnName = resultSet.getString("COLUMN_NAME");
            if (columnName == null) continue;
            String indexName = resultSet.getString("INDEX_NAME");
            boolean noUnique = resultSet.getBoolean("NON_UNIQUE");
            ConstraintKey constraintKey = constraintKeyMap.computeIfAbsent(indexName, s -> {
                ConstraintKey.ConstraintType constraintType = ConstraintKey.ConstraintType.KEY;
                if (!noUnique) {
                    constraintType = ConstraintKey.ConstraintType.UNIQUE_KEY;
                }
                return ConstraintKey.of((ConstraintKey.ConstraintType)constraintType, (String)indexName, new ArrayList());
            });
            ConstraintKey.ColumnSortType sortType = "A".equals(resultSet.getString("ASC_OR_DESC")) ? ConstraintKey.ColumnSortType.ASC : ConstraintKey.ColumnSortType.DESC;
            ConstraintKey.ConstraintKeyColumn constraintKeyColumn = new ConstraintKey.ConstraintKeyColumn(columnName, sortType);
            constraintKey.getColumnNames().add(constraintKeyColumn);
        }
        return new ArrayList<ConstraintKey>(constraintKeyMap.values());
    }

    protected Optional<String> getColumnDefaultValue(DatabaseMetaData metaData, String database, String schema, String table, String column) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(database, schema, table, column);){
            if (resultSet.next()) {
                String defaultValue = resultSet.getString("COLUMN_DEF");
                Optional<String> optional = Optional.ofNullable(defaultValue);
                return optional;
            }
        }
        return Optional.empty();
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)databaseName));
        return this.listDatabases().contains(databaseName);
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        try {
            return this.databaseExists(tablePath.getDatabaseName()) && this.listTables(tablePath.getDatabaseName()).contains(tablePath.getTableName());
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"Table path cannot be null");
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.catalogName, tablePath.getDatabaseName());
        }
        if (this.defaultSchema.isPresent()) {
            tablePath = new TablePath(tablePath.getDatabaseName(), this.defaultSchema.get(), tablePath.getTableName());
        }
        if (!this.createTableInternal(tablePath, table) && !ignoreIfExists) {
            throw new TableAlreadyExistException(this.catalogName, tablePath);
        }
    }

    protected abstract boolean createTableInternal(TablePath var1, CatalogTable var2) throws CatalogException;

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"Table path cannot be null");
        if (!this.dropTableInternal(tablePath) && !ignoreIfNotExists) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
    }

    protected abstract boolean dropTableInternal(TablePath var1) throws CatalogException;

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"Table path cannot be null");
        Preconditions.checkNotNull((Object)tablePath.getDatabaseName(), (Object)"Database name cannot be null");
        if (this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseAlreadyExistException(this.catalogName, tablePath.getDatabaseName());
        }
        if (!this.createDatabaseInternal(tablePath.getDatabaseName()) && !ignoreIfExists) {
            throw new DatabaseAlreadyExistException(this.catalogName, tablePath.getDatabaseName());
        }
    }

    protected abstract boolean createDatabaseInternal(String var1);

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"Table path cannot be null");
        Preconditions.checkNotNull((Object)tablePath.getDatabaseName(), (Object)"Database name cannot be null");
        if (!this.dropDatabaseInternal(tablePath.getDatabaseName()) && !ignoreIfNotExists) {
            throw new DatabaseNotExistException(this.catalogName, tablePath.getDatabaseName());
        }
    }

    protected abstract boolean dropDatabaseInternal(String var1) throws CatalogException;
}

