/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle.OracleCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle.OracleDataTypeConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleCatalog
extends AbstractJdbcCatalog {
    private static final Logger log = LoggerFactory.getLogger(OracleCatalog.class);
    private static final OracleDataTypeConvertor DATA_TYPE_CONVERTOR = new OracleDataTypeConvertor();
    private static final List<String> EXCLUDED_SCHEMAS = Collections.unmodifiableList(Arrays.asList("APPQOSSYS", "AUDSYS", "CTXSYS", "DVSYS", "DBSFWUSER", "DBSNMP", "GSMADMIN_INTERNAL", "LBACSYS", "MDSYS", "OJVMSYS", "OLAPSYS", "ORDDATA", "ORDSYS", "OUTLN", "SYS", "SYSTEM", "WMSYS", "XDB", "EXFSYS", "SYSMAN"));
    private static final String SELECT_COLUMNS_SQL = "SELECT\n    cols.COLUMN_NAME,\n    CASE \n        WHEN cols.data_type LIKE 'INTERVAL%%' THEN 'INTERVAL'\n        ELSE REGEXP_SUBSTR(cols.data_type, '^[^(]+')\n    END as TYPE_NAME,\n    cols.data_type || \n        CASE \n            WHEN cols.data_type IN ('VARCHAR2', 'CHAR') THEN '(' || cols.data_length || ')'\n            WHEN cols.data_type IN ('NUMBER') AND cols.data_precision IS NOT NULL AND cols.data_scale IS NOT NULL THEN '(' || cols.data_precision || ', ' || cols.data_scale || ')'\n            WHEN cols.data_type IN ('NUMBER') AND cols.data_precision IS NOT NULL AND cols.data_scale IS NULL THEN '(' || cols.data_precision || ')'\n            WHEN cols.data_type IN ('RAW') THEN '(' || cols.data_length || ')'\n        END AS FULL_TYPE_NAME,\n    cols.data_length AS COLUMN_LENGTH,\n    cols.data_precision AS COLUMN_PRECISION,\n    cols.data_scale AS COLUMN_SCALE,\n    com.comments AS COLUMN_COMMENT,\n    cols.data_default AS DEFAULT_VALUE,\n    CASE cols.nullable WHEN 'N' THEN 'NO' ELSE 'YES' END AS IS_NULLABLE\nFROM\n    all_tab_columns cols\nLEFT JOIN \n    all_col_comments com ON cols.table_name = com.table_name AND cols.column_name = com.column_name AND cols.owner = com.owner\nWHERE \n    cols.owner = '%s'\n    AND cols.table_name = '%s'\nORDER BY \n    cols.column_id \n";

    public OracleCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo, String defaultSchema) {
        super(catalogName, username, pwd, urlInfo, defaultSchema);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listDatabases() throws CatalogException {
        try (PreparedStatement ps = this.defaultConnection.prepareStatement("SELECT name FROM v$database");){
            ArrayList<String> databases = new ArrayList<String>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String databaseName = rs.getString(1);
                databases.add(databaseName);
            }
            ArrayList<String> arrayList = databases;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    @Override
    protected boolean createTableInternal(TablePath tablePath, CatalogTable table) throws CatalogException {
        String[] createTableSqls;
        String createTableSql = new OracleCreateTableSqlBuilder(table).build(tablePath);
        for (String sql : createTableSqls = createTableSql.split(";")) {
            log.info("create table sql: {}", (Object)sql);
            try (PreparedStatement ps = this.defaultConnection.prepareStatement(sql);){
                ps.execute();
            }
            catch (Exception e) {
                throw new CatalogException(String.format("Failed creating table %s", tablePath.getFullName()), (Throwable)e);
            }
        }
        return true;
    }

    @Override
    protected boolean dropTableInternal(TablePath tablePath) throws CatalogException {
        return false;
    }

    @Override
    protected boolean createDatabaseInternal(String databaseName) {
        return false;
    }

    @Override
    protected boolean dropDatabaseInternal(String databaseName) throws CatalogException {
        return false;
    }

    @Override
    public boolean tableExists(TablePath tablePath) throws CatalogException {
        try {
            return this.databaseExists(tablePath.getDatabaseName()) && this.listTables(tablePath.getDatabaseName()).contains(tablePath.getSchemaAndTableName().toUpperCase());
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        try (PreparedStatement ps = this.defaultConnection.prepareStatement("SELECT OWNER, TABLE_NAME FROM ALL_TABLES\nWHERE TABLE_NAME NOT LIKE 'MDRT_%'\n  AND TABLE_NAME NOT LIKE 'MDRS_%'\n  AND TABLE_NAME NOT LIKE 'MDXT_%'\n  AND (TABLE_NAME NOT LIKE 'SYS_IOT_OVER_%' AND IOT_NAME IS NULL)");){
            ResultSet rs = ps.executeQuery();
            ArrayList<String> tables = new ArrayList<String>();
            while (rs.next()) {
                if (EXCLUDED_SCHEMAS.contains(rs.getString(1))) continue;
                tables.add(rs.getString(1) + "." + rs.getString(2));
            }
            ArrayList<String> arrayList = tables;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void buildColumn(ResultSet resultSet, TableSchema.Builder builder) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String typeName = resultSet.getString("TYPE_NAME");
        String fullTypeName = resultSet.getString("FULL_TYPE_NAME");
        long columnLength = resultSet.getLong("COLUMN_LENGTH");
        long columnPrecision = resultSet.getLong("COLUMN_PRECISION");
        long columnScale = resultSet.getLong("COLUMN_SCALE");
        String columnComment = resultSet.getString("COLUMN_COMMENT");
        Object defaultValue = resultSet.getObject("DEFAULT_VALUE");
        boolean isNullable = resultSet.getString("IS_NULLABLE").equals("YES");
        SeaTunnelDataType<?> type = this.fromJdbcType(typeName, columnPrecision, columnScale);
        long bitLen = 0L;
        switch (typeName) {
            case "LONG": 
            case "ROWID": 
            case "NCLOB": 
            case "CLOB": {
                columnLength = -1L;
                break;
            }
            case "RAW": {
                bitLen = 16000L;
                break;
            }
            case "BLOB": 
            case "LONG RAW": 
            case "BFILE": {
                bitLen = -1L;
                break;
            }
        }
        PhysicalColumn physicalColumn = PhysicalColumn.of((String)columnName, type, (Integer)0, (boolean)isNullable, (Object)defaultValue, (String)columnComment, (String)fullTypeName, (boolean)false, (boolean)false, (Long)bitLen, null, (Long)columnLength);
        builder.column((Column)physicalColumn);
    }

    private SeaTunnelDataType<?> fromJdbcType(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String columnType = metadata.getColumnTypeName(colIndex);
        HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
        dataTypeProperties.put("precision", metadata.getPrecision(colIndex));
        dataTypeProperties.put("scale", metadata.getScale(colIndex));
        return DATA_TYPE_CONVERTOR.toSeaTunnelType(columnType, dataTypeProperties);
    }

    private SeaTunnelDataType<?> fromJdbcType(String typeName, long precision, long scale) {
        HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
        dataTypeProperties.put("precision", precision);
        dataTypeProperties.put("scale", scale);
        return DATA_TYPE_CONVERTOR.toSeaTunnelType(typeName, dataTypeProperties);
    }

    private Map<String, String> buildConnectorOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>(8);
        options.put("connector", "jdbc");
        options.put("url", this.baseUrl);
        options.put("table-name", tablePath.getSchemaAndTableName());
        options.put("username", this.username);
        options.put("password", this.pwd);
        return options;
    }
}

