/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertException;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;

@AutoService(value={DataTypeConvertor.class})
public class OracleDataTypeConvertor
implements DataTypeConvertor<String> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 38;
    public static final Integer DEFAULT_SCALE = 18;
    public static final String ORACLE_UNKNOWN = "UNKNOWN";
    public static final String ORACLE_BINARY_DOUBLE = "BINARY_DOUBLE";
    public static final String ORACLE_BINARY_FLOAT = "BINARY_FLOAT";
    public static final String ORACLE_NUMBER = "NUMBER";
    public static final String ORACLE_FLOAT = "FLOAT";
    public static final String ORACLE_REAL = "REAL";
    public static final String ORACLE_INTEGER = "INTEGER";
    public static final String ORACLE_CHAR = "CHAR";
    public static final String ORACLE_VARCHAR2 = "VARCHAR2";
    public static final String ORACLE_NCHAR = "NCHAR";
    public static final String ORACLE_NVARCHAR2 = "NVARCHAR2";
    public static final String ORACLE_LONG = "LONG";
    public static final String ORACLE_ROWID = "ROWID";
    public static final String ORACLE_CLOB = "CLOB";
    public static final String ORACLE_NCLOB = "NCLOB";
    public static final String ORACLE_DATE = "DATE";
    public static final String ORACLE_TIMESTAMP = "TIMESTAMP";
    public static final String ORACLE_TIMESTAMP_WITH_LOCAL_TIME_ZONE = "TIMESTAMP WITH LOCAL TIME ZONE";
    public static final String ORACLE_BLOB = "BLOB";
    public static final String ORACLE_BFILE = "BFILE";
    public static final String ORACLE_RAW = "RAW";
    public static final String ORACLE_LONG_RAW = "LONG RAW";

    public SeaTunnelDataType<?> toSeaTunnelType(String connectorDataType) {
        return this.toSeaTunnelType(connectorDataType, Collections.emptyMap());
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String connectorDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Preconditions.checkNotNull((Object)connectorDataType, (Object)"Oracle Type cannot be null");
        switch (connectorDataType = OracleDataTypeConvertor.normalizeTimestamp(connectorDataType)) {
            case "INTEGER": {
                return BasicType.INT_TYPE;
            }
            case "FLOAT": {
                return new DecimalType(38, 18);
            }
            case "NUMBER": {
                int precision = MapUtils.getInteger(dataTypeProperties, (Object)PRECISION, (Integer)DEFAULT_PRECISION);
                int scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE, (Integer)DEFAULT_SCALE);
                if (scale == 0) {
                    if (precision == 1) {
                        return BasicType.BOOLEAN_TYPE;
                    }
                    if (precision <= 9) {
                        return BasicType.INT_TYPE;
                    }
                    if (precision <= 18) {
                        return BasicType.LONG_TYPE;
                    }
                }
                return new DecimalType(38, 18);
            }
            case "BINARY_DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "BINARY_FLOAT": 
            case "REAL": {
                return BasicType.FLOAT_TYPE;
            }
            case "CHAR": 
            case "NCHAR": 
            case "NVARCHAR2": 
            case "VARCHAR2": 
            case "LONG": 
            case "ROWID": 
            case "NCLOB": 
            case "CLOB": {
                return BasicType.STRING_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIMESTAMP": 
            case "TIMESTAMP WITH LOCAL TIME ZONE": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "BLOB": 
            case "RAW": 
            case "LONG RAW": 
            case "BFILE": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Doesn't support ORACLE type '%s' yet.", connectorDataType));
    }

    public String toConnectorType(SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Preconditions.checkNotNull(seaTunnelDataType, (Object)"seaTunnelDataType cannot be null");
        SqlType sqlType = seaTunnelDataType.getSqlType();
        switch (sqlType) {
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                return ORACLE_INTEGER;
            }
            case BIGINT: {
                return ORACLE_NUMBER;
            }
            case FLOAT: {
                return ORACLE_FLOAT;
            }
            case DOUBLE: {
                return ORACLE_BINARY_DOUBLE;
            }
            case DECIMAL: {
                return ORACLE_NUMBER;
            }
            case BOOLEAN: {
                return ORACLE_NUMBER;
            }
            case STRING: {
                return ORACLE_VARCHAR2;
            }
            case DATE: {
                return ORACLE_DATE;
            }
            case TIMESTAMP: {
                return ORACLE_TIMESTAMP_WITH_LOCAL_TIME_ZONE;
            }
            case BYTES: {
                return ORACLE_BLOB;
            }
        }
        throw new UnsupportedOperationException(String.format("Doesn't support SeaTunnel type '%s' yet.", seaTunnelDataType));
    }

    public static String normalizeTimestamp(String oracleType) {
        String pattern = "^TIMESTAMP(\\([0-9]\\))?$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(oracleType);
        if (m.find()) {
            return ORACLE_TIMESTAMP;
        }
        return oracleType;
    }

    public String getIdentity() {
        return "Oracle";
    }
}

