/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Optional;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.AbstractJdbcRowConverter;

public class PostgresJdbcRowConverter
extends AbstractJdbcRowConverter {
    private static final String PG_GEOMETRY = "GEOMETRY";
    private static final String PG_GEOGRAPHY = "GEOGRAPHY";

    @Override
    public String converterName() {
        return null;
    }

    @Override
    public SeaTunnelRow toInternal(ResultSet rs, SeaTunnelRowType typeInfo) throws SQLException {
        Object[] fields = new Object[typeInfo.getTotalFields()];
        block16: for (int fieldIndex = 0; fieldIndex < typeInfo.getTotalFields(); ++fieldIndex) {
            SeaTunnelDataType seaTunnelDataType = typeInfo.getFieldType(fieldIndex);
            int resultSetIndex = fieldIndex + 1;
            String metaDataColumnType = rs.getMetaData().getColumnTypeName(resultSetIndex).toUpperCase(Locale.ROOT);
            switch (seaTunnelDataType.getSqlType()) {
                case STRING: {
                    if (metaDataColumnType.equals(PG_GEOMETRY) || metaDataColumnType.equals(PG_GEOGRAPHY)) {
                        fields[fieldIndex] = rs.getObject(resultSetIndex) == null ? null : rs.getObject(resultSetIndex).toString();
                        continue block16;
                    }
                    fields[fieldIndex] = rs.getString(resultSetIndex);
                    continue block16;
                }
                case BOOLEAN: {
                    fields[fieldIndex] = rs.getBoolean(resultSetIndex);
                    continue block16;
                }
                case TINYINT: {
                    fields[fieldIndex] = rs.getByte(resultSetIndex);
                    continue block16;
                }
                case SMALLINT: {
                    fields[fieldIndex] = rs.getShort(resultSetIndex);
                    continue block16;
                }
                case INT: {
                    fields[fieldIndex] = rs.getInt(resultSetIndex);
                    continue block16;
                }
                case BIGINT: {
                    fields[fieldIndex] = rs.getLong(resultSetIndex);
                    continue block16;
                }
                case FLOAT: {
                    fields[fieldIndex] = Float.valueOf(rs.getFloat(resultSetIndex));
                    continue block16;
                }
                case DOUBLE: {
                    fields[fieldIndex] = rs.getDouble(resultSetIndex);
                    continue block16;
                }
                case DECIMAL: {
                    fields[fieldIndex] = rs.getBigDecimal(resultSetIndex);
                    continue block16;
                }
                case DATE: {
                    Date sqlDate = rs.getDate(resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlDate).map(e -> e.toLocalDate()).orElse(null);
                    continue block16;
                }
                case TIME: {
                    Time sqlTime = rs.getTime(resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlTime).map(e -> e.toLocalTime()).orElse(null);
                    continue block16;
                }
                case TIMESTAMP: {
                    Timestamp sqlTimestamp = rs.getTimestamp(resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlTimestamp).map(e -> e.toLocalDateTime()).orElse(null);
                    continue block16;
                }
                case BYTES: {
                    fields[fieldIndex] = rs.getBytes(resultSetIndex);
                    continue block16;
                }
                case NULL: {
                    fields[fieldIndex] = null;
                    continue block16;
                }
                default: {
                    throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                }
            }
        }
        return new SeaTunnelRow(fields);
    }
}

