/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.teradata;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;

public class TeradataTypeMapper
implements JdbcDialectTypeMapper {
    private static final String TERADATA_BYTEINT = "BYTEINT";
    private static final String TERADATA_SMALLINT = "SMALLINT";
    private static final String TERADATA_INTEGER = "INTEGER";
    private static final String TERADATA_BIGINT = "BIGINT";
    private static final String TERADATA_FLOAT = "FLOAT";
    private static final String TERADATA_DECIMAL = "DECIMAL";
    private static final String TERADATA_CHAR = "CHAR";
    private static final String TERADATA_VARCHAR = "VARCHAR";
    private static final String TERADATA_CLOB = "CLOB";
    private static final String TERADATA_BYTE = "BYTE";
    private static final String TERADATA_VARBYTE = "VARBYTE";
    private static final String TERADATA_DATE = "DATE";
    private static final String TERADATA_TIME = "TIME";
    private static final String TERADATA_TIMESTAMP = "TIMESTAMP";
    private static final String TERADATA_BLOB = "BLOB";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String teradataType;
        switch (teradataType = metadata.getColumnTypeName(colIndex).toUpperCase()) {
            case "BYTEINT": {
                return BasicType.BYTE_TYPE;
            }
            case "SMALLINT": {
                return BasicType.SHORT_TYPE;
            }
            case "INTEGER": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "DECIMAL": {
                return new DecimalType(metadata.getPrecision(colIndex), metadata.getScale(colIndex));
            }
            case "CHAR": 
            case "VARCHAR": 
            case "CLOB": {
                return BasicType.STRING_TYPE;
            }
            case "BYTE": 
            case "VARBYTE": 
            case "BLOB": {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "TIMESTAMP": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("Doesn't support TERADATA type '%s' on column '%s'  yet.", teradataType, jdbcColumnName));
    }
}

