/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor.StatementFactory;

public class InsertOrUpdateBatchStatementExecutor
implements JdbcBatchStatementExecutor<SeaTunnelRow> {
    private final StatementFactory existStmtFactory;
    @NonNull
    private final StatementFactory insertStmtFactory;
    @NonNull
    private final StatementFactory updateStmtFactory;
    private final SeaTunnelRowType keyRowType;
    private final Function<SeaTunnelRow, SeaTunnelRow> keyExtractor;
    @NonNull
    private final SeaTunnelRowType valueRowType;
    @NonNull
    private final JdbcRowConverter rowConverter;
    private transient PreparedStatement existStatement;
    private transient PreparedStatement insertStatement;
    private transient PreparedStatement updateStatement;
    private transient Boolean preExistFlag;
    private transient boolean submitted;

    public InsertOrUpdateBatchStatementExecutor(StatementFactory insertStmtFactory, StatementFactory updateStmtFactory, SeaTunnelRowType valueRowType, JdbcRowConverter rowConverter) {
        this(null, insertStmtFactory, updateStmtFactory, null, null, valueRowType, rowConverter);
    }

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        if (this.upsertMode()) {
            this.existStatement = this.existStmtFactory.createStatement(connection);
        }
        this.insertStatement = this.insertStmtFactory.createStatement(connection);
        this.updateStatement = this.updateStmtFactory.createStatement(connection);
    }

    @Override
    public void addToBatch(SeaTunnelRow record) throws SQLException {
        boolean exist = this.existRow(record);
        if (exist) {
            if (this.preExistFlag != null && !this.preExistFlag.booleanValue()) {
                this.insertStatement.executeBatch();
                this.insertStatement.clearBatch();
            }
            this.rowConverter.toExternal(this.valueRowType, record, this.updateStatement);
            this.updateStatement.addBatch();
        } else {
            if (this.preExistFlag != null && this.preExistFlag.booleanValue()) {
                this.updateStatement.executeBatch();
                this.updateStatement.clearBatch();
            }
            this.rowConverter.toExternal(this.valueRowType, record, this.insertStatement);
            this.insertStatement.addBatch();
        }
        this.preExistFlag = exist;
        this.submitted = false;
    }

    @Override
    public void executeBatch() throws SQLException {
        if (this.preExistFlag != null) {
            if (this.preExistFlag.booleanValue()) {
                this.updateStatement.executeBatch();
                this.updateStatement.clearBatch();
            } else {
                this.insertStatement.executeBatch();
                this.insertStatement.clearBatch();
            }
        }
        this.submitted = true;
    }

    @Override
    public void closeStatements() throws SQLException {
        if (!this.submitted) {
            this.executeBatch();
        }
        for (PreparedStatement statement : Arrays.asList(this.existStatement, this.insertStatement, this.updateStatement)) {
            if (statement == null) continue;
            statement.close();
        }
    }

    private boolean upsertMode() {
        return this.existStmtFactory != null;
    }

    private boolean existRow(SeaTunnelRow record) throws SQLException {
        if (this.upsertMode()) {
            return this.exist(this.keyExtractor.apply(record));
        }
        switch (record.getRowKind()) {
            case INSERT: {
                return false;
            }
            case UPDATE_AFTER: {
                return true;
            }
        }
        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, "unsupported row kind: " + record.getRowKind());
    }

    private boolean exist(SeaTunnelRow pk) throws SQLException {
        this.rowConverter.toExternal(this.keyRowType, pk, this.existStatement);
        try (ResultSet resultSet = this.existStatement.executeQuery();){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    public InsertOrUpdateBatchStatementExecutor(StatementFactory existStmtFactory, @NonNull StatementFactory insertStmtFactory, @NonNull StatementFactory updateStmtFactory, SeaTunnelRowType keyRowType, Function<SeaTunnelRow, SeaTunnelRow> keyExtractor, @NonNull SeaTunnelRowType valueRowType, @NonNull JdbcRowConverter rowConverter) {
        if (insertStmtFactory == null) {
            throw new NullPointerException("insertStmtFactory is marked non-null but is null");
        }
        if (updateStmtFactory == null) {
            throw new NullPointerException("updateStmtFactory is marked non-null but is null");
        }
        if (valueRowType == null) {
            throw new NullPointerException("valueRowType is marked non-null but is null");
        }
        if (rowConverter == null) {
            throw new NullPointerException("rowConverter is marked non-null but is null");
        }
        this.existStmtFactory = existStmtFactory;
        this.insertStmtFactory = insertStmtFactory;
        this.updateStmtFactory = updateStmtFactory;
        this.keyRowType = keyRowType;
        this.keyExtractor = keyExtractor;
        this.valueRowType = valueRowType;
        this.rowConverter = rowConverter;
    }
}

