/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.sink;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableFactoryContext;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcSink;

@AutoService(value={Factory.class})
public class JdbcSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Jdbc";
    }

    public TableSink createSink(TableFactoryContext context) {
        ReadonlyConfig config = context.getOptions();
        CatalogTable catalogTable = context.getCatalogTable();
        Map catalogOptions = (Map)config.get(CatalogOptions.CATALOG_OPTIONS);
        Optional optionalTable = config.getOptional(JdbcOptions.TABLE);
        if (!optionalTable.isPresent()) {
            catalogOptions = catalogOptions == null ? new HashMap() : catalogOptions;
            String prefix = (String)catalogOptions.get(JdbcCatalogOptions.TABLE_PREFIX.key());
            String suffix = (String)catalogOptions.get(JdbcCatalogOptions.TABLE_SUFFIX.key());
            if (StringUtils.isNotEmpty((CharSequence)prefix) || StringUtils.isNotEmpty((CharSequence)suffix)) {
                TableIdentifier tableId = catalogTable.getTableId();
                String tableName = StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + tableId.getTableName() : tableId.getTableName();
                tableName = StringUtils.isNotEmpty((CharSequence)suffix) ? tableName + suffix : tableName;
                TableIdentifier newTableId = TableIdentifier.of((String)tableId.getCatalogName(), (String)tableId.getDatabaseName(), (String)tableId.getSchemaName(), (String)tableName);
                catalogTable = CatalogTable.of((TableIdentifier)newTableId, (TableSchema)catalogTable.getTableSchema(), (Map)catalogTable.getOptions(), (List)catalogTable.getPartitionKeys(), (String)catalogTable.getCatalogName());
            }
            Map map = config.toMap();
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)catalogOptions.get(JdbcCatalogOptions.SCHEMA.key())))) {
                map.put(JdbcOptions.TABLE.key(), (String)catalogOptions.get(JdbcCatalogOptions.SCHEMA.key()) + "." + catalogTable.getTableId().getTableName());
            } else if (StringUtils.isNotBlank((CharSequence)catalogTable.getTableId().getSchemaName())) {
                map.put(JdbcOptions.TABLE.key(), catalogTable.getTableId().getSchemaName() + "." + catalogTable.getTableId().getTableName());
            } else {
                map.put(JdbcOptions.TABLE.key(), catalogTable.getTableId().getTableName());
            }
            PrimaryKey primaryKey = catalogTable.getTableSchema().getPrimaryKey();
            if (primaryKey != null && !CollectionUtils.isEmpty((Collection)primaryKey.getColumnNames())) {
                map.put(JdbcOptions.PRIMARY_KEYS.key(), String.join((CharSequence)",", primaryKey.getColumnNames()));
            } else {
                Optional<ConstraintKey> keyOptional = catalogTable.getTableSchema().getConstraintKeys().stream().filter(key -> ConstraintKey.ConstraintType.UNIQUE_KEY.equals((Object)key.getConstraintType())).findFirst();
                if (keyOptional.isPresent()) {
                    map.put(JdbcOptions.PRIMARY_KEYS.key(), keyOptional.get().getColumnNames().stream().map(key -> key.getColumnName()).collect(Collectors.joining(",")));
                }
            }
            config = ReadonlyConfig.fromMap(new HashMap(map));
        }
        ReadonlyConfig options = config;
        JdbcSinkConfig sinkConfig = JdbcSinkConfig.of(config);
        JdbcDialect dialect = JdbcDialectLoader.load(sinkConfig.getJdbcConnectionConfig().getUrl(), sinkConfig.getJdbcConnectionConfig().getCompatibleMode());
        CatalogTable finalCatalogTable = catalogTable;
        return () -> new JdbcSink(options, sinkConfig, dialect, DataSaveMode.KEEP_SCHEMA_AND_DATA, finalCatalogTable);
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{JdbcOptions.URL, JdbcOptions.DRIVER}).optional(new Option[]{JdbcOptions.USER, JdbcOptions.PASSWORD, JdbcOptions.CONNECTION_CHECK_TIMEOUT_SEC, JdbcOptions.BATCH_SIZE, JdbcOptions.IS_EXACTLY_ONCE, JdbcOptions.GENERATE_SINK_SQL, JdbcOptions.AUTO_COMMIT, JdbcOptions.SUPPORT_UPSERT_BY_QUERY_PRIMARY_KEY_EXIST, JdbcOptions.PRIMARY_KEYS, JdbcOptions.COMPATIBLE_MODE}).conditional(JdbcOptions.IS_EXACTLY_ONCE, (Object)true, new Option[]{JdbcOptions.XA_DATA_SOURCE_CLASS_NAME, JdbcOptions.MAX_COMMIT_ATTEMPTS, JdbcOptions.TRANSACTION_TIMEOUT_SEC}).conditional(JdbcOptions.IS_EXACTLY_ONCE, (Object)false, new Option[]{JdbcOptions.MAX_RETRIES}).conditional(JdbcOptions.GENERATE_SINK_SQL, (Object)true, new Option[]{JdbcOptions.DATABASE}).conditional(JdbcOptions.GENERATE_SINK_SQL, (Object)false, new Option[]{JdbcOptions.QUERY}).build();
    }
}

