/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.split.JdbcNumericBetweenParametersProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.PartitionParameter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSourceSplitEnumerator
implements SourceSplitEnumerator<JdbcSourceSplit, JdbcSourceState> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcSourceSplitEnumerator.class);
    private final SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext;
    private final Map<Integer, List<JdbcSourceSplit>> pendingSplits;
    private final Object stateLock = new Object();
    private volatile boolean shouldEnumerate;
    private JdbcSourceConfig jdbcSourceConfig;
    private final PartitionParameter partitionParameter;

    public JdbcSourceSplitEnumerator(SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext, JdbcSourceConfig jdbcSourceConfig, PartitionParameter partitionParameter) {
        this(enumeratorContext, jdbcSourceConfig, partitionParameter, null);
    }

    public JdbcSourceSplitEnumerator(SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext, JdbcSourceConfig jdbcSourceConfig, PartitionParameter partitionParameter, JdbcSourceState sourceState) {
        this.enumeratorContext = enumeratorContext;
        this.jdbcSourceConfig = jdbcSourceConfig;
        this.partitionParameter = partitionParameter;
        this.pendingSplits = new HashMap<Integer, List<JdbcSourceSplit>>();
        boolean bl = this.shouldEnumerate = sourceState == null;
        if (sourceState != null) {
            this.shouldEnumerate = sourceState.isShouldEnumerate();
            this.pendingSplits.putAll(sourceState.getPendingSplits());
        }
    }

    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Set readers = this.enumeratorContext.registeredReaders();
        if (this.shouldEnumerate) {
            Set<JdbcSourceSplit> newSplits = this.discoverySplits();
            Object object = this.stateLock;
            synchronized (object) {
                this.addPendingSplit(newSplits);
                this.shouldEnumerate = false;
            }
            this.assignSplit(readers);
        }
        LOG.debug("No more splits to assign. Sending NoMoreSplitsEvent to reader {}.", (Object)readers);
        readers.forEach(arg_0 -> this.enumeratorContext.signalNoMoreSplits(arg_0));
    }

    private Set<JdbcSourceSplit> discoverySplits() {
        HashSet<JdbcSourceSplit> allSplit = new HashSet<JdbcSourceSplit>();
        LOG.info("Starting to calculate splits.");
        if (null != this.partitionParameter) {
            int partitionNumber;
            int n = partitionNumber = this.partitionParameter.getPartitionNumber() != null ? this.partitionParameter.getPartitionNumber().intValue() : this.enumeratorContext.currentParallelism();
            if (this.partitionParameter.getDataType().equals((Object)BasicType.STRING_TYPE)) {
                for (int i = 0; i < partitionNumber; ++i) {
                    allSplit.add(new JdbcSourceSplit(new Object[]{i}, i));
                }
            } else {
                JdbcNumericBetweenParametersProvider jdbcNumericBetweenParametersProvider = new JdbcNumericBetweenParametersProvider(this.partitionParameter.getMinValue(), this.partitionParameter.getMaxValue()).ofBatchNum(partitionNumber);
                Serializable[][] parameterValues = jdbcNumericBetweenParametersProvider.getParameterValues();
                for (int i = 0; i < parameterValues.length; ++i) {
                    allSplit.add(new JdbcSourceSplit(parameterValues[i], i));
                }
            }
        } else {
            allSplit.add(new JdbcSourceSplit(null, 0));
        }
        return allSplit;
    }

    public void close() throws IOException {
    }

    public void addSplitsBack(List<JdbcSourceSplit> splits, int subtaskId) {
        LOG.debug("Add back splits {} to JdbcSourceSplitEnumerator.", splits);
        if (!splits.isEmpty()) {
            this.addPendingSplit(splits);
            this.assignSplit(Collections.singletonList(subtaskId));
        }
    }

    private void addPendingSplit(Collection<JdbcSourceSplit> splits) {
        int readerCount = this.enumeratorContext.currentParallelism();
        for (JdbcSourceSplit split : splits) {
            int ownerReader = JdbcSourceSplitEnumerator.getSplitOwner(split.splitId(), readerCount);
            LOG.info("Assigning {} to {} reader.", (Object)split, (Object)ownerReader);
            this.pendingSplits.computeIfAbsent(ownerReader, r -> new ArrayList()).add(split);
        }
    }

    private static int getSplitOwner(String tp, int numReaders) {
        return (tp.hashCode() & Integer.MAX_VALUE) % numReaders;
    }

    private void assignSplit(Collection<Integer> readers) {
        LOG.debug("Assign pendingSplits to readers {}", readers);
        for (int reader : readers) {
            List<JdbcSourceSplit> assignmentForReader = this.pendingSplits.remove(reader);
            if (assignmentForReader == null || assignmentForReader.isEmpty()) continue;
            LOG.info("Assign splits {} to reader {}", assignmentForReader, (Object)reader);
            try {
                this.enumeratorContext.assignSplit(reader, assignmentForReader);
            }
            catch (Exception e) {
                LOG.error("Failed to assign splits {} to reader {}", new Object[]{assignmentForReader, reader, e});
                this.pendingSplits.put(reader, assignmentForReader);
            }
        }
    }

    public int currentUnassignedSplitSize() {
        return this.pendingSplits.size();
    }

    public void handleSplitRequest(int subtaskId) {
        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Unsupported handleSplitRequest: %d", subtaskId));
    }

    public void registerReader(int subtaskId) {
        LOG.debug("Register reader {} to JdbcSourceSplitEnumerator.", (Object)subtaskId);
        if (!this.pendingSplits.isEmpty()) {
            this.assignSplit(Collections.singletonList(subtaskId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcSourceState snapshotState(long checkpointId) throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            return new JdbcSourceState(this.shouldEnumerate, this.pendingSplits);
        }
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

