/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.dm;

import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonError;

@AutoService(value={DataTypeConvertor.class})
public class DamengDataTypeConvertor
implements DataTypeConvertor<String> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 38;
    public static final Integer DEFAULT_SCALE = 18;
    private static final String DM_BIT = "BIT";
    private static final String DM_NUMERIC = "NUMERIC";
    private static final String DM_NUMBER = "NUMBER";
    private static final String DM_DECIMAL = "DECIMAL";
    private static final String DM_DEC = "DEC";
    private static final String DM_INTEGER = "INTEGER";
    private static final String DM_INT = "INT";
    public static final String DM_PLS_INTEGER = "PLS_INTEGER";
    private static final String DM_BIGINT = "BIGINT";
    private static final String DM_TINYINT = "TINYINT";
    private static final String DM_BYTE = "BYTE";
    private static final String DM_SMALLINT = "SMALLINT";
    private static final String DM_FLOAT = "FLOAT";
    private static final String DM_DOUBLE = "DOUBLE";
    private static final String DM_DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String DM_REAL = "REAL";
    private static final String DM_CHAR = "CHAR";
    private static final String DM_CHARACTER = "CHARACTER";
    private static final String DM_VARCHAR = "VARCHAR";
    private static final String DM_VARCHAR2 = "VARCHAR2";
    private static final String DM_LONGVARCHAR = "LONGVARCHAR";
    private static final String DM_CLOB = "CLOB";
    private static final String DM_TEXT = "TEXT";
    private static final String DM_LONG = "LONG";
    private static final String DM_DATE = "DATE";
    private static final String DM_TIME = "TIME";
    private static final String DM_TIMESTAMP = "TIMESTAMP";
    private static final String DM_DATETIME = "DATETIME";
    private static final String DM_BINARY = "BINARY";
    private static final String DM_VARBINARY = "VARBINARY";
    private static final String DM_INTERVAL_YEAR_TO_MONTH = "INTERVAL YEAR TO MONTH";
    private static final String DM_INTERVAL_YEAR = "INTERVAL YEAR";
    private static final String DM_INTERVAL_MONTH = "INTERVAL MONTH";
    private static final String DM_INTERVAL_DAY = "INTERVAL DAY";
    private static final String DM_INTERVAL_DAY_TO_HOUR = "INTERVAL DAY TO HOUR";
    private static final String DM_INTERVAL_DAY_TO_MINUTE = "INTERVAL DAY TO MINUTE";
    private static final String DM_INTERVAL_DAY_TO_SECOND = "INTERVAL DAY TO SECOND";
    private static final String DM_INTERVAL_HOUR = "INTERVAL HOUR";
    private static final String DM_INTERVAL_HOUR_TO_MINUTE = "INTERVAL HOUR TO MINUTE";
    private static final String DM_INTERVAL_HOUR_TO_SECOND = "INTERVAL HOUR TO SECOND";
    private static final String DM_INTERVAL_MINUTE = "INTERVAL MINUTE";
    private static final String DM_INTERVAL_MINUTE_TO_SECOND = "INTERVAL MINUTE TO SECOND";
    private static final String DM_INTERVAL_SECOND = "INTERVAL SECOND";
    private static final String DM_TIME_WITH_TIME_ZONE = "TIME WITH TIME ZONE";
    private static final String DM_TIMESTAMP_WITH_TIME_ZONE = "TIMESTAMP WITH TIME ZONE";
    private static final String TIMESTAMP_WITH_LOCAL_TIME_ZONE = "TIMESTAMP WITH LOCAL TIME ZONE";
    public static final String DM_BLOB = "BLOB";
    public static final String DM_BFILE = "BFILE";
    public static final String DM_IMAGE = "IMAGE";
    public static final String DM_LONGVARBINARY = "LONGVARBINARY";

    public String getIdentity() {
        return "Dameng";
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String dataType) {
        return this.toSeaTunnelType(field, dataType, Collections.emptyMap());
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String dataType, Map<String, Object> properties) {
        switch (dataType.toUpperCase()) {
            case "BIT": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "TINYINT": 
            case "BYTE": {
                return BasicType.BYTE_TYPE;
            }
            case "SMALLINT": {
                return BasicType.SHORT_TYPE;
            }
            case "INT": 
            case "INTEGER": 
            case "PLS_INTEGER": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "NUMERIC": 
            case "NUMBER": 
            case "DECIMAL": 
            case "DEC": {
                int precision = MapUtils.getInteger(properties, (Object)PRECISION, (Integer)DEFAULT_PRECISION);
                int scale = MapUtils.getInteger(properties, (Object)SCALE, (Integer)DEFAULT_SCALE);
                if (precision > 0) {
                    return new DecimalType(precision, scale);
                }
                return new DecimalType(38, 18);
            }
            case "REAL": {
                return BasicType.FLOAT_TYPE;
            }
            case "FLOAT": 
            case "DOUBLE PRECISION": 
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "CHAR": 
            case "CHARACTER": 
            case "VARCHAR": 
            case "VARCHAR2": 
            case "TEXT": 
            case "LONG": 
            case "LONGVARCHAR": 
            case "CLOB": {
                return BasicType.STRING_TYPE;
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "BLOB": 
            case "BINARY": 
            case "VARBINARY": 
            case "LONGVARBINARY": 
            case "IMAGE": 
            case "BFILE": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        throw CommonError.convertToSeaTunnelTypeError((String)"Dameng", (String)dataType, (String)field);
    }

    public String toConnectorType(String field, SeaTunnelDataType<?> dataType, Map<String, Object> properties) {
        SqlType sqlType = dataType.getSqlType();
        switch (sqlType) {
            case TINYINT: {
                return DM_TINYINT;
            }
            case SMALLINT: {
                return DM_SMALLINT;
            }
            case INT: {
                return DM_INT;
            }
            case BIGINT: {
                return DM_BIGINT;
            }
            case FLOAT: {
                return DM_REAL;
            }
            case DOUBLE: {
                return DM_DOUBLE;
            }
            case DECIMAL: {
                return DM_DECIMAL;
            }
            case BOOLEAN: {
                return DM_BIT;
            }
            case STRING: {
                return DM_VARCHAR2;
            }
            case DATE: {
                return DM_DATE;
            }
            case TIME: {
                return DM_TIME;
            }
            case TIMESTAMP: {
                return DM_TIMESTAMP;
            }
            case BYTES: {
                return DM_BINARY;
            }
        }
        throw CommonError.convertToConnectorTypeError((String)"Dameng", (String)dataType.toString(), (String)field);
    }
}

