/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql;

import com.mysql.cj.MysqlType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql.MysqlCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql.MysqlDataTypeConvertor;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql.MySqlTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlCatalog
extends AbstractJdbcCatalog {
    private static final Logger log = LoggerFactory.getLogger(MySqlCatalog.class);
    private static final MysqlDataTypeConvertor DATA_TYPE_CONVERTOR = new MysqlDataTypeConvertor();
    private static final String SELECT_COLUMNS_SQL_TEMPLATE = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME ='%s' ORDER BY ORDINAL_POSITION ASC";

    public MySqlCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo) {
        super(catalogName, username, pwd, urlInfo, null);
    }

    @Override
    protected String getListDatabaseSql() {
        return "SHOW DATABASES;";
    }

    @Override
    protected String getListTableSql(String databaseName) {
        return "SHOW TABLES;";
    }

    @Override
    protected String getTableName(ResultSet rs) throws SQLException {
        return rs.getString(1);
    }

    @Override
    protected String getTableName(TablePath tablePath) {
        return tablePath.getTableName();
    }

    @Override
    protected String getSelectColumnsSql(TablePath tablePath) {
        return String.format(SELECT_COLUMNS_SQL_TEMPLATE, tablePath.getDatabaseName(), tablePath.getTableName());
    }

    @Override
    protected TableIdentifier getTableIdentifier(TablePath tablePath) {
        return TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName());
    }

    @Override
    protected Column buildColumn(ResultSet resultSet) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String sourceType = resultSet.getString("COLUMN_TYPE");
        String typeName = resultSet.getString("DATA_TYPE").toUpperCase();
        int precision = resultSet.getInt("NUMERIC_PRECISION");
        int scale = resultSet.getInt("NUMERIC_SCALE");
        long columnLength = resultSet.getLong("CHARACTER_MAXIMUM_LENGTH");
        long octetLength = resultSet.getLong("CHARACTER_OCTET_LENGTH");
        if (sourceType.toLowerCase(Locale.ROOT).contains("unsigned")) {
            typeName = typeName + "_UNSIGNED";
        }
        SeaTunnelDataType<?> type = this.fromJdbcType(columnName, typeName, precision, scale);
        String comment = resultSet.getString("COLUMN_COMMENT");
        Object defaultValue = resultSet.getObject("COLUMN_DEFAULT");
        String isNullableStr = resultSet.getString("IS_NULLABLE");
        boolean isNullable = isNullableStr.equals("YES");
        long bitLen = 0L;
        MysqlType mysqlType = MysqlType.valueOf((String)typeName);
        switch (mysqlType) {
            case BIT: {
                bitLen = precision;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                columnLength = octetLength;
                break;
            }
            case BINARY: 
            case VARBINARY: {
                bitLen = octetLength * 4L * 8L;
                break;
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                bitLen = columnLength << 3;
                break;
            }
            case JSON: {
                columnLength = 0x100000000L;
                break;
            }
        }
        return PhysicalColumn.of((String)columnName, type, (Integer)0, (boolean)isNullable, (Object)defaultValue, (String)comment, (String)sourceType, (boolean)sourceType.contains("unsigned"), (boolean)sourceType.contains("zerofill"), (Long)bitLen, null, (Long)columnLength);
    }

    @Override
    protected String getCreateTableSql(TablePath tablePath, CatalogTable table) {
        return MysqlCreateTableSqlBuilder.builder(tablePath, table).build(table.getCatalogName());
    }

    @Override
    protected String getDropTableSql(TablePath tablePath) {
        return String.format("DROP TABLE `%s`.`%s`;", tablePath.getDatabaseName(), tablePath.getTableName());
    }

    @Override
    protected String getCreateDatabaseSql(String databaseName) {
        return String.format("CREATE DATABASE `%s`;", databaseName);
    }

    @Override
    protected String getDropDatabaseSql(String databaseName) {
        return String.format("DROP DATABASE `%s`;", databaseName);
    }

    private SeaTunnelDataType<?> fromJdbcType(String columnName, String typeName, int precision, int scale) {
        MysqlType mysqlType = MysqlType.getByName((String)typeName);
        HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
        dataTypeProperties.put("precision", precision);
        dataTypeProperties.put("scale", scale);
        return DATA_TYPE_CONVERTOR.toSeaTunnelType(columnName, mysqlType, dataTypeProperties);
    }

    @Override
    public CatalogTable getTable(String sqlQuery) throws SQLException {
        Connection defaultConnection = this.getConnection(this.defaultUrl);
        return CatalogUtils.getCatalogTable(defaultConnection, sqlQuery, new MySqlTypeMapper());
    }

    @Override
    protected String getTruncateTableSql(TablePath tablePath) throws CatalogException {
        return String.format("TRUNCATE TABLE `%s`.`%s`;", tablePath.getDatabaseName(), tablePath.getTableName());
    }

    @Override
    public String getExistDataSql(TablePath tablePath) {
        return String.format("SELECT * FROM `%s`.`%s` LIMIT 1;", tablePath.getDatabaseName(), tablePath.getTableName());
    }

    static {
        SYS_DATABASES.add("information_schema");
        SYS_DATABASES.add("mysql");
        SYS_DATABASES.add("performance_schema");
        SYS_DATABASES.add("sys");
    }
}

