/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql;

import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql.MysqlDataTypeConvertor;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class MysqlCreateTableSqlBuilder {
    private final String tableName;
    private List<Column> columns;
    private String comment;
    private String engine;
    private String charset;
    private String collate;
    private PrimaryKey primaryKey;
    private List<ConstraintKey> constraintKeys;
    private MysqlDataTypeConvertor mysqlDataTypeConvertor;
    private String fieldIde;

    private MysqlCreateTableSqlBuilder(String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName must not be null");
        this.tableName = tableName;
        this.mysqlDataTypeConvertor = new MysqlDataTypeConvertor();
    }

    public static MysqlCreateTableSqlBuilder builder(TablePath tablePath, CatalogTable catalogTable) {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath must not be null");
        Preconditions.checkNotNull((Object)catalogTable, (Object)"catalogTable must not be null");
        TableSchema tableSchema = catalogTable.getTableSchema();
        Preconditions.checkNotNull((Object)tableSchema, (Object)"tableSchema must not be null");
        return new MysqlCreateTableSqlBuilder(tablePath.getTableName()).comment(catalogTable.getComment()).engine(null).charset(null).primaryKey(tableSchema.getPrimaryKey()).constraintKeys(tableSchema.getConstraintKeys()).addColumn(tableSchema.getColumns()).fieldIde((String)catalogTable.getOptions().get("fieldIde"));
    }

    public MysqlCreateTableSqlBuilder addColumn(List<Column> columns) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columns), (Object)"columns must not be empty");
        this.columns = columns;
        return this;
    }

    public MysqlCreateTableSqlBuilder primaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public MysqlCreateTableSqlBuilder fieldIde(String fieldIde) {
        this.fieldIde = fieldIde;
        return this;
    }

    public MysqlCreateTableSqlBuilder constraintKeys(List<ConstraintKey> constraintKeys) {
        this.constraintKeys = constraintKeys;
        return this;
    }

    public MysqlCreateTableSqlBuilder engine(String engine) {
        this.engine = engine;
        return this;
    }

    public MysqlCreateTableSqlBuilder charset(String charset) {
        this.charset = charset;
        return this;
    }

    public MysqlCreateTableSqlBuilder collate(String collate) {
        this.collate = collate;
        return this;
    }

    public MysqlCreateTableSqlBuilder comment(String comment) {
        this.comment = comment;
        return this;
    }

    public String build(String catalogName) {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(String.format("CREATE TABLE %s (\n%s\n)", CatalogUtils.quoteIdentifier(this.tableName, this.fieldIde, "`"), this.buildColumnsIdentifySql(catalogName)));
        if (this.engine != null) {
            sqls.add("ENGINE = " + this.engine);
        }
        if (this.charset != null) {
            sqls.add("DEFAULT CHARSET = " + this.charset);
        }
        if (this.collate != null) {
            sqls.add("COLLATE = " + this.collate);
        }
        if (this.comment != null) {
            sqls.add("COMMENT = '" + this.comment + "'");
        }
        return String.join((CharSequence)" ", sqls) + ";";
    }

    private String buildColumnsIdentifySql(String catalogName) {
        ArrayList<String> columnSqls = new ArrayList<String>();
        for (Column column : this.columns) {
            columnSqls.add("\t" + this.buildColumnIdentifySql(column, catalogName));
        }
        if (this.primaryKey != null) {
            columnSqls.add("\t" + this.buildPrimaryKeySql());
        }
        if (CollectionUtils.isNotEmpty(this.constraintKeys)) {
            for (ConstraintKey constraintKey : this.constraintKeys) {
                if (!StringUtils.isBlank((CharSequence)constraintKey.getConstraintName())) continue;
            }
        }
        return String.join((CharSequence)", \n", columnSqls);
    }

    private String buildColumnIdentifySql(Column column, String catalogName) {
        ArrayList<String> columnSqls = new ArrayList<String>();
        columnSqls.add(CatalogUtils.quoteIdentifier(column.getName(), this.fieldIde, "`"));
        boolean isSupportDef = true;
        if (StringUtils.equals((CharSequence)catalogName, (CharSequence)"MySQL")) {
            columnSqls.add(column.getSourceType());
        } else {
            this.getColumnName(column, columnSqls);
        }
        if (column.isNullable()) {
            columnSqls.add("NULL");
        } else {
            columnSqls.add("NOT NULL");
        }
        if (column.getComment() != null) {
            columnSqls.add("COMMENT '" + column.getComment() + "'");
        }
        return String.join((CharSequence)" ", columnSqls);
    }

    private void getColumnName(Column column, List<String> columnSqls) {
        SqlType dataType = column.getDataType().getSqlType();
        boolean isBytes = StringUtils.equals((CharSequence)dataType.name(), (CharSequence)SqlType.BYTES.name());
        Long columnLength = column.getLongColumnLength();
        Long bitLen = column.getBitLen();
        if (isBytes) {
            this.getColumnNameBytes(columnSqls, bitLen);
        } else {
            this.getColumnNameNonBytes(column, columnSqls, columnLength);
        }
    }

    private void getColumnNameNonBytes(Column column, List<String> columnSqls, Long columnLength) {
        if ((columnLength = Long.valueOf(columnLength == null ? Integer.MAX_VALUE : columnLength)) >= 16383L && columnLength <= 65535L) {
            columnSqls.add(MysqlType.TEXT.getName());
        } else if (columnLength >= 65535L && columnLength <= 0xFFFFFFL) {
            columnSqls.add(MysqlType.MEDIUMTEXT.getName());
        } else if (columnLength > 0xFFFFFFL || columnLength == -1L) {
            columnSqls.add(MysqlType.LONGTEXT.getName());
        } else {
            String name = this.mysqlDataTypeConvertor.toConnectorType(column.getName(), column.getDataType(), null).getName();
            if (columnLength == 0L && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)MysqlType.VARCHAR.getName())) {
                columnSqls.add(MysqlType.LONGTEXT.getName());
                return;
            }
            columnSqls.add(this.mysqlDataTypeConvertor.toConnectorType(column.getName(), column.getDataType(), null).getName());
            String fieSql = "";
            ArrayList<String> list = new ArrayList<String>();
            list.add(MysqlType.VARCHAR.getName());
            list.add(MysqlType.CHAR.getName());
            list.add(MysqlType.BIGINT.getName());
            list.add(MysqlType.INT.getName());
            if (StringUtils.equals((CharSequence)name, (CharSequence)MysqlType.DECIMAL.getName())) {
                DecimalType decimalType = (DecimalType)column.getDataType();
                fieSql = String.format("(%d, %d)", decimalType.getPrecision(), decimalType.getScale());
                columnSqls.add(fieSql);
                return;
            }
            if (list.contains(name)) {
                fieSql = MysqlType.VARCHAR.getName().equals(name) ? "(" + column.getLongColumnLength() + ")" : (MysqlType.CHAR.getName().equals(name) ? "(" + column.getLongColumnLength() + ")" : "(" + (column.getLongColumnLength().equals(0L) ? 11L : column.getLongColumnLength()) + ")");
                columnSqls.add(fieSql);
            }
        }
    }

    private void getColumnNameBytes(List<String> columnSqls, Long bitLen) {
        if ((bitLen = Long.valueOf(bitLen == null ? Integer.MAX_VALUE : bitLen)) > 0L && bitLen <= 64L) {
            columnSqls.add(MysqlType.BIT.getName());
            columnSqls.add("(" + bitLen + ")");
        } else if ((bitLen = Long.valueOf(bitLen == -1L ? bitLen : bitLen >> 3)) >= 0L && bitLen <= 255L) {
            columnSqls.add(MysqlType.TINYBLOB.getName());
        } else if (bitLen <= 16383L) {
            columnSqls.add(MysqlType.BLOB.getName());
        } else if (bitLen <= 0xFFFFFFL) {
            columnSqls.add(MysqlType.MEDIUMBLOB.getName());
        } else {
            columnSqls.add(MysqlType.LONGBLOB.getName());
        }
    }

    private String buildPrimaryKeySql() {
        String key = this.primaryKey.getColumnNames().stream().map(columnName -> "`" + columnName + "`").collect(Collectors.joining(", "));
        return String.format("PRIMARY KEY (%s)", CatalogUtils.quoteIdentifier(key, this.fieldIde));
    }

    private String buildConstraintKeySql(ConstraintKey constraintKey) {
        ConstraintKey.ConstraintType constraintType = constraintKey.getConstraintType();
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> {
            if (constraintKeyColumn.getSortType() == null) {
                return String.format("`%s`", constraintKeyColumn.getColumnName());
            }
            return String.format("`%s` %s", constraintKeyColumn.getColumnName(), constraintKeyColumn.getSortType().name());
        }).collect(Collectors.joining(", "));
        String keyName = null;
        switch (constraintType) {
            case INDEX_KEY: {
                keyName = "KEY";
                break;
            }
            case UNIQUE_KEY: {
                keyName = "UNIQUE KEY";
                break;
            }
            case FOREIGN_KEY: {
                keyName = "FOREIGN KEY";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported constraint type: " + constraintType);
            }
        }
        return String.format("%s `%s` (%s)", keyName, constraintKey.getConstraintName(), indexColumns);
    }
}

