/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver.SqlServerCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver.SqlServerDataTypeConvertor;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver.SqlServerType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlserverTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerCatalog
extends AbstractJdbcCatalog {
    private static final Logger log = LoggerFactory.getLogger(SqlServerCatalog.class);
    private static final SqlServerDataTypeConvertor DATA_TYPE_CONVERTOR = new SqlServerDataTypeConvertor();
    private static final String SELECT_COLUMNS_SQL_TEMPLATE = "SELECT tbl.name AS table_name,\n       col.name AS column_name,\n       ext.value AS comment,\n       col.column_id AS column_id,\n       types.name AS type,\n       col.max_length AS max_length,\n       col.precision AS precision,\n       col.scale AS scale,\n       col.is_nullable AS is_nullable,\n       def.definition AS default_value\nFROM sys.tables tbl\n    INNER JOIN sys.columns col ON tbl.object_id = col.object_id\n    LEFT JOIN sys.types types ON col.user_type_id = types.user_type_id\n    LEFT JOIN sys.extended_properties ext ON ext.major_id = col.object_id AND ext.minor_id = col.column_id\n    LEFT JOIN sys.default_constraints def ON col.default_object_id = def.object_id AND ext.minor_id = col.column_id AND ext.name = 'MS_Description'\nWHERE schema_name(tbl.schema_id) = '%s' %s\nORDER BY tbl.name, col.column_id";

    public SqlServerCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo, String defaultSchema) {
        super(catalogName, username, pwd, urlInfo, defaultSchema);
    }

    @Override
    protected String getListDatabaseSql() {
        return "SELECT NAME FROM sys.databases";
    }

    @Override
    protected String getListTableSql(String databaseName) {
        return "SELECT TABLE_SCHEMA, TABLE_NAME FROM " + databaseName + ".INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'BASE TABLE'";
    }

    @Override
    protected String getSelectColumnsSql(TablePath tablePath) {
        String tableSql = StringUtils.isNotEmpty((CharSequence)tablePath.getTableName()) ? "AND tbl.name = '" + tablePath.getTableName() + "'" : "";
        return String.format(SELECT_COLUMNS_SQL_TEMPLATE, tablePath.getSchemaName(), tableSql);
    }

    @Override
    protected Column buildColumn(ResultSet resultSet) throws SQLException {
        String columnName = resultSet.getString("column_name");
        String sourceType = resultSet.getString("type");
        int precision = resultSet.getInt("precision");
        int scale = resultSet.getInt("scale");
        long columnLength = resultSet.getLong("max_length");
        SeaTunnelDataType<?> type = this.fromJdbcType(columnName, sourceType, precision, scale);
        String comment = resultSet.getString("comment");
        Object defaultValue = resultSet.getObject("default_value");
        if (defaultValue != null) {
            defaultValue = defaultValue.toString().replace("(", "").replace("'", "").replace(")", "");
        }
        boolean isNullable = resultSet.getBoolean("is_nullable");
        long bitLen = 0L;
        StringBuilder sb = new StringBuilder(sourceType);
        Pair<SqlServerType, Map<String, Object>> parse = SqlServerType.parse(sourceType);
        switch ((SqlServerType)parse.getLeft()) {
            case BINARY: 
            case VARBINARY: {
                if (columnLength != -1L) {
                    bitLen = columnLength * 4L * 8L;
                    sourceType = sb.append("(").append(columnLength).append(")").toString();
                    break;
                }
                sourceType = sb.append("(").append("max").append(")").toString();
                bitLen = columnLength;
                break;
            }
            case TIMESTAMP: {
                bitLen = columnLength << 3;
                break;
            }
            case VARCHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case CHAR: {
                if (columnLength != -1L) {
                    sourceType = sb.append("(").append(columnLength).append(")").toString();
                    break;
                }
                sourceType = sb.append("(").append("max").append(")").toString();
                break;
            }
            case DECIMAL: 
            case NUMERIC: {
                sourceType = sb.append("(").append(precision).append(",").append(scale).append(")").toString();
                break;
            }
            case TEXT: {
                columnLength = Integer.MAX_VALUE;
                break;
            }
            case NTEXT: {
                columnLength = 0x3FFFFFFFL;
                break;
            }
            case IMAGE: {
                bitLen = 0x3FFFFFFF8L;
                break;
            }
        }
        return PhysicalColumn.of((String)columnName, type, (Integer)0, (boolean)isNullable, (Object)defaultValue, (String)comment, (String)sourceType, (boolean)false, (boolean)false, (Long)bitLen, null, (Long)columnLength);
    }

    private SeaTunnelDataType<?> fromJdbcType(String columnName, String typeName, int precision, int scale) {
        Pair<SqlServerType, Map<String, Object>> pair = SqlServerType.parse(typeName);
        HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
        dataTypeProperties.put("precision", precision);
        dataTypeProperties.put("scale", scale);
        return DATA_TYPE_CONVERTOR.toSeaTunnelType(columnName, (SqlServerType)pair.getLeft(), dataTypeProperties);
    }

    @Override
    protected String getCreateTableSql(TablePath tablePath, CatalogTable table) {
        return SqlServerCreateTableSqlBuilder.builder(tablePath, table).build(tablePath, table);
    }

    @Override
    protected String getDropTableSql(TablePath tablePath) {
        return String.format("DROP TABLE %s", tablePath.getFullName());
    }

    @Override
    protected String getCreateDatabaseSql(String databaseName) {
        return String.format("CREATE DATABASE %s", databaseName);
    }

    @Override
    protected String getDropDatabaseSql(String databaseName) {
        return String.format("DROP DATABASE %s;", databaseName);
    }

    @Override
    protected void dropDatabaseInternal(String databaseName) throws CatalogException {
        this.closeDatabaseConnection(databaseName);
        super.dropDatabaseInternal(databaseName);
    }

    @Override
    protected String getUrlFromDatabaseName(String databaseName) {
        return this.baseUrl + ";databaseName=" + databaseName + ";" + this.suffix;
    }

    @Override
    public boolean tableExists(TablePath tablePath) throws CatalogException {
        try {
            if (StringUtils.isNotBlank((CharSequence)tablePath.getDatabaseName())) {
                return this.databaseExists(tablePath.getDatabaseName()) && this.listTables(tablePath.getDatabaseName()).contains(tablePath.getSchemaAndTableName());
            }
            return this.listTables(this.defaultDatabase).contains(tablePath.getSchemaAndTableName());
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
    }

    @Override
    public CatalogTable getTable(String sqlQuery) throws SQLException {
        Connection defaultConnection = this.getConnection(this.defaultUrl);
        return CatalogUtils.getCatalogTable(defaultConnection, sqlQuery, new SqlserverTypeMapper());
    }

    @Override
    public String getExistDataSql(TablePath tablePath) {
        return String.format("select TOP 1 * from %s ;", tablePath.getFullNameWithQuoted("[", "]"));
    }

    @Override
    protected String getTruncateTableSql(TablePath tablePath) throws CatalogException {
        return String.format("TRUNCATE TABLE  %s", tablePath.getFullNameWithQuoted("[", "]"));
    }
}

