/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver;

import com.google.auto.service.AutoService;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver.SqlServerType;

@AutoService(value={DataTypeConvertor.class})
public class SqlServerDataTypeConvertor
implements DataTypeConvertor<SqlServerType> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 10;
    public static final Integer DEFAULT_SCALE = 0;

    public SeaTunnelDataType<?> toSeaTunnelType(String field, @NonNull String connectorDataType) {
        if (connectorDataType == null) {
            throw new NullPointerException("connectorDataType is marked non-null but is null");
        }
        Pair<SqlServerType, Map<String, Object>> sqlServerType = SqlServerType.parse(connectorDataType);
        return this.toSeaTunnelType(field, (SqlServerType)sqlServerType.getLeft(), (Map<String, Object>)((Map)sqlServerType.getRight()));
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field, @NonNull SqlServerType connectorDataType, Map<String, Object> dataTypeProperties) {
        if (connectorDataType == null) {
            throw new NullPointerException("connectorDataType is marked non-null but is null");
        }
        switch (connectorDataType) {
            case BIT: {
                return BasicType.BOOLEAN_TYPE;
            }
            case TINYINT: 
            case SMALLINT: {
                return BasicType.SHORT_TYPE;
            }
            case INTEGER: 
            case INT_IDENTITY: {
                return BasicType.INT_TYPE;
            }
            case BIGINT: {
                return BasicType.LONG_TYPE;
            }
            case DECIMAL: 
            case NUMERIC: 
            case MONEY: 
            case SMALLMONEY: {
                int precision = (Integer)dataTypeProperties.getOrDefault(PRECISION, DEFAULT_PRECISION);
                int scale = (Integer)dataTypeProperties.getOrDefault(SCALE, DEFAULT_SCALE);
                return new DecimalType(precision, scale);
            }
            case REAL: {
                return BasicType.FLOAT_TYPE;
            }
            case FLOAT: {
                return BasicType.DOUBLE_TYPE;
            }
            case CHAR: 
            case NCHAR: 
            case VARCHAR: 
            case NTEXT: 
            case NVARCHAR: 
            case TEXT: 
            case XML: 
            case GUID: 
            case SQL_VARIANT: {
                return BasicType.STRING_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case TIME: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case DATETIME: 
            case DATETIME2: 
            case SMALLDATETIME: 
            case DATETIMEOFFSET: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case TIMESTAMP: 
            case BINARY: 
            case VARBINARY: 
            case IMAGE: {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        throw CommonError.convertToSeaTunnelTypeError((String)"SqlServer", (String)connectorDataType.toString(), (String)field);
    }

    public SqlServerType toConnectorType(String field, SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) {
        SqlType sqlType = seaTunnelDataType.getSqlType();
        switch (sqlType) {
            case STRING: {
                return SqlServerType.VARCHAR;
            }
            case BOOLEAN: {
                return SqlServerType.BIT;
            }
            case TINYINT: {
                return SqlServerType.TINYINT;
            }
            case SMALLINT: {
                return SqlServerType.SMALLINT;
            }
            case INT: {
                return SqlServerType.INTEGER;
            }
            case BIGINT: {
                return SqlServerType.BIGINT;
            }
            case FLOAT: {
                return SqlServerType.REAL;
            }
            case DOUBLE: {
                return SqlServerType.FLOAT;
            }
            case DECIMAL: {
                return SqlServerType.DECIMAL;
            }
            case BYTES: {
                return SqlServerType.BINARY;
            }
            case DATE: {
                return SqlServerType.DATE;
            }
            case TIME: {
                return SqlServerType.TIME;
            }
            case TIMESTAMP: {
                return SqlServerType.DATETIME2;
            }
        }
        throw CommonError.convertToConnectorTypeError((String)"SqlServer", (String)seaTunnelDataType.getSqlType().toString(), (String)field);
    }

    public String getIdentity() {
        return "SqlServer";
    }
}

