/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.redshift;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedshiftTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(RedshiftTypeMapper.class);
    private static final String REDSHIFT_SMALLINT = "SMALLINT";
    private static final String REDSHIFT_INT2 = "INT2";
    private static final String REDSHIFT_INTEGER = "INTEGER";
    private static final String REDSHIFT_INT = "INT";
    private static final String REDSHIFT_INT4 = "INT4";
    private static final String REDSHIFT_BIGINT = "BIGINT";
    private static final String REDSHIFT_INT8 = "INT8";
    private static final String REDSHIFT_DECIMAL = "DECIMAL";
    private static final String REDSHIFT_NUMERIC = "NUMERIC";
    private static final String REDSHIFT_REAL = "REAL";
    private static final String REDSHIFT_FLOAT4 = "FLOAT4";
    private static final String REDSHIFT_DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String REDSHIFT_FLOAT8 = "FLOAT8";
    private static final String REDSHIFT_FLOAT = "FLOAT";
    private static final String REDSHIFT_BOOLEAN = "BOOLEAN";
    private static final String REDSHIFT_BOOL = "BOOL";
    private static final String REDSHIFT_CHAR = "CHAR";
    private static final String REDSHIFT_CHARACTER = "CHARACTER";
    private static final String REDSHIFT_NCHAR = "NCHAR";
    private static final String REDSHIFT_BPCHAR = "BPCHAR";
    private static final String REDSHIFT_VARCHAR = "VARCHAR";
    private static final String REDSHIFT_CHARACTER_VARYING = "CHARACTER VARYING";
    private static final String REDSHIFT_NVARCHAR = "NVARCHAR";
    private static final String REDSHIFT_TEXT = "TEXT";
    private static final String REDSHIFT_DATE = "DATE";
    private static final String REDSHIFT_GEOMETRY = "GEOMETRY";
    private static final String REDSHIFT_OID = "OID";
    private static final String REDSHIFT_SUPER = "SUPER";
    private static final String REDSHIFT_TIME = "TIME";
    private static final String REDSHIFT_TIME_WITH_TIME_ZONE = "TIME WITH TIME ZONE";
    private static final String REDSHIFT_TIMETZ = "TIMETZ";
    private static final String REDSHIFT_TIMESTAMP = "TIMESTAMP";
    private static final String REDSHIFT_TIMESTAMP_WITH_OUT_TIME_ZONE = "TIMESTAMP WITHOUT TIME ZONE";
    private static final String REDSHIFT_TIMESTAMPTZ = "TIMESTAMPTZ";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String redshiftType = metadata.getColumnTypeName(colIndex).toUpperCase();
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (redshiftType) {
            case "SMALLINT": 
            case "INT2": {
                return BasicType.SHORT_TYPE;
            }
            case "INTEGER": 
            case "INT": 
            case "INT4": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": 
            case "INT8": 
            case "OID": {
                return BasicType.LONG_TYPE;
            }
            case "DECIMAL": 
            case "NUMERIC": {
                return new DecimalType(precision, scale);
            }
            case "REAL": 
            case "FLOAT4": {
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE PRECISION": 
            case "FLOAT8": 
            case "FLOAT": {
                return BasicType.DOUBLE_TYPE;
            }
            case "BOOLEAN": 
            case "BOOL": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "CHAR": 
            case "CHARACTER": 
            case "NCHAR": 
            case "BPCHAR": 
            case "VARCHAR": 
            case "CHARACTER VARYING": 
            case "NVARCHAR": 
            case "TEXT": 
            case "SUPER": {
                return BasicType.STRING_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "GEOMETRY": {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case "TIME": 
            case "TIME WITH TIME ZONE": 
            case "TIMETZ": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "TIMESTAMP": 
            case "TIMESTAMP WITHOUT TIME ZONE": 
            case "TIMESTAMPTZ": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw CommonError.convertToSeaTunnelTypeError((String)"Redshift", (String)redshiftType, (String)jdbcColumnName);
    }
}

