/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.DefaultSaveModeHandler;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcExactlyOnceSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcSinkAggregatedCommitter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcSinkState;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.XidInfo;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.JdbcCatalogUtils;

public class JdbcSink
implements SeaTunnelSink<SeaTunnelRow, JdbcSinkState, XidInfo, JdbcAggregatedCommitInfo>,
SupportSaveMode,
SupportMultiTableSink {
    private final TableSchema tableSchema;
    private JobContext jobContext;
    private final JdbcSinkConfig jdbcSinkConfig;
    private final JdbcDialect dialect;
    private final ReadonlyConfig config;
    private final DataSaveMode dataSaveMode;
    private final SchemaSaveMode schemaSaveMode;
    private final CatalogTable catalogTable;

    public JdbcSink(ReadonlyConfig config, JdbcSinkConfig jdbcSinkConfig, JdbcDialect dialect, SchemaSaveMode schemaSaveMode, DataSaveMode dataSaveMode, CatalogTable catalogTable) {
        this.config = config;
        this.jdbcSinkConfig = jdbcSinkConfig;
        this.dialect = dialect;
        this.schemaSaveMode = schemaSaveMode;
        this.dataSaveMode = dataSaveMode;
        this.catalogTable = catalogTable;
        this.tableSchema = catalogTable.getTableSchema();
    }

    public String getPluginName() {
        return "Jdbc";
    }

    public SinkWriter<SeaTunnelRow, XidInfo, JdbcSinkState> createWriter(SinkWriter.Context context) {
        Object sinkWriter;
        if (this.jdbcSinkConfig.isExactlyOnce()) {
            sinkWriter = new JdbcExactlyOnceSinkWriter(context, this.jobContext, this.dialect, this.jdbcSinkConfig, this.tableSchema, new ArrayList<JdbcSinkState>());
        } else {
            if (this.catalogTable != null && this.catalogTable.getTableSchema().getPrimaryKey() != null) {
                String keyName = (String)this.tableSchema.getPrimaryKey().getColumnNames().get(0);
                int index = this.tableSchema.toPhysicalRowDataType().indexOf(keyName);
                if (index > -1) {
                    return new JdbcSinkWriter(this.dialect, this.jdbcSinkConfig, this.tableSchema, index);
                }
            }
            sinkWriter = new JdbcSinkWriter(this.dialect, this.jdbcSinkConfig, this.tableSchema, null);
        }
        return sinkWriter;
    }

    public SinkWriter<SeaTunnelRow, XidInfo, JdbcSinkState> restoreWriter(SinkWriter.Context context, List<JdbcSinkState> states) throws IOException {
        if (this.jdbcSinkConfig.isExactlyOnce()) {
            return new JdbcExactlyOnceSinkWriter(context, this.jobContext, this.dialect, this.jdbcSinkConfig, this.tableSchema, states);
        }
        return super.restoreWriter(context, states);
    }

    public Optional<SinkAggregatedCommitter<XidInfo, JdbcAggregatedCommitInfo>> createAggregatedCommitter() {
        if (this.jdbcSinkConfig.isExactlyOnce()) {
            return Optional.of(new JdbcSinkAggregatedCommitter(this.jdbcSinkConfig));
        }
        return Optional.empty();
    }

    public Optional<Serializer<JdbcAggregatedCommitInfo>> getAggregatedCommitInfoSerializer() {
        if (this.jdbcSinkConfig.isExactlyOnce()) {
            return Optional.of(new DefaultSerializer());
        }
        return Optional.empty();
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public Optional<Serializer<XidInfo>> getCommitInfoSerializer() {
        if (this.jdbcSinkConfig.isExactlyOnce()) {
            return Optional.of(new DefaultSerializer());
        }
        return Optional.empty();
    }

    public Optional<SaveModeHandler> getSaveModeHandler() {
        if (this.catalogTable != null) {
            if (StringUtils.isBlank((CharSequence)this.jdbcSinkConfig.getDatabase())) {
                return Optional.empty();
            }
            if (StringUtils.isBlank((CharSequence)this.jdbcSinkConfig.getTable())) {
                return Optional.empty();
            }
            if (StringUtils.isNotBlank((CharSequence)this.jdbcSinkConfig.getSimpleSql())) {
                return Optional.empty();
            }
            Optional<Catalog> catalogOptional = JdbcCatalogUtils.findCatalog(this.jdbcSinkConfig.getJdbcConnectionConfig(), this.dialect);
            if (catalogOptional.isPresent()) {
                try {
                    Catalog catalog = catalogOptional.get();
                    catalog.open();
                    FieldIdeEnum fieldIdeEnumEnum = (FieldIdeEnum)((Object)this.config.get(JdbcOptions.FIELD_IDE));
                    String fieldIde = fieldIdeEnumEnum == null ? FieldIdeEnum.ORIGINAL.getValue() : fieldIdeEnumEnum.getValue();
                    TablePath tablePath = TablePath.of((String)this.catalogTable.getTableId().getDatabaseName(), (String)this.catalogTable.getTableId().getSchemaName(), (String)CatalogUtils.quoteTableIdentifier(this.catalogTable.getTableId().getTableName(), fieldIde));
                    this.catalogTable.getOptions().put("fieldIde", fieldIde);
                    return Optional.of(new DefaultSaveModeHandler(this.schemaSaveMode, this.dataSaveMode, catalog, tablePath, this.catalogTable, (String)this.config.get(JdbcOptions.CUSTOM_SQL)));
                }
                catch (Exception e) {
                    throw new JdbcConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.HANDLE_SAVE_MODE_FAILED, e);
                }
            }
        }
        return Optional.empty();
    }
}

