/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlServerTypeConverter;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class SqlServerCreateTableSqlBuilder {
    private final String tableName;
    private List<Column> columns;
    private String comment;
    private String engine;
    private String charset;
    private String collate;
    private PrimaryKey primaryKey;
    private List<ConstraintKey> constraintKeys;
    private String fieldIde;

    private SqlServerCreateTableSqlBuilder(String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName must not be null");
        this.tableName = tableName;
    }

    public static SqlServerCreateTableSqlBuilder builder(TablePath tablePath, CatalogTable catalogTable) {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath must not be null");
        Preconditions.checkNotNull((Object)catalogTable, (Object)"catalogTable must not be null");
        TableSchema tableSchema = catalogTable.getTableSchema();
        Preconditions.checkNotNull((Object)tableSchema, (Object)"tableSchema must not be null");
        return new SqlServerCreateTableSqlBuilder(tablePath.getTableName()).comment(catalogTable.getComment()).engine(null).charset(null).primaryKey(tableSchema.getPrimaryKey()).constraintKeys(tableSchema.getConstraintKeys()).addColumn(tableSchema.getColumns()).fieldIde((String)catalogTable.getOptions().get("fieldIde"));
    }

    public SqlServerCreateTableSqlBuilder addColumn(List<Column> columns) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columns), (Object)"columns must not be empty");
        this.columns = columns;
        return this;
    }

    public SqlServerCreateTableSqlBuilder primaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public SqlServerCreateTableSqlBuilder fieldIde(String fieldIde) {
        this.fieldIde = fieldIde;
        return this;
    }

    public SqlServerCreateTableSqlBuilder constraintKeys(List<ConstraintKey> constraintKeys) {
        this.constraintKeys = constraintKeys;
        return this;
    }

    public SqlServerCreateTableSqlBuilder engine(String engine) {
        this.engine = engine;
        return this;
    }

    public SqlServerCreateTableSqlBuilder charset(String charset) {
        this.charset = charset;
        return this;
    }

    public SqlServerCreateTableSqlBuilder collate(String collate) {
        this.collate = collate;
        return this;
    }

    public SqlServerCreateTableSqlBuilder comment(String comment) {
        this.comment = comment;
        return this;
    }

    public String build(TablePath tablePath, CatalogTable catalogTable) {
        ArrayList<String> sqls = new ArrayList<String>();
        String sqlTableName = tablePath.getFullNameWithQuoted("[", "]");
        HashMap<String, String> columnComments = new HashMap<String, String>();
        sqls.add(String.format("IF OBJECT_ID('%s', 'U') IS NULL \nBEGIN \nCREATE TABLE %s ( \n%s\n)", sqlTableName, sqlTableName, this.buildColumnsIdentifySql(catalogTable.getCatalogName(), columnComments)));
        if (this.engine != null) {
            sqls.add("ENGINE = " + this.engine);
        }
        if (this.charset != null) {
            sqls.add("DEFAULT CHARSET = " + this.charset);
        }
        if (this.collate != null) {
            sqls.add("COLLATE = " + this.collate);
        }
        String sqlTableSql = String.join((CharSequence)" ", sqls) + ";";
        sqlTableSql = CatalogUtils.quoteIdentifier(sqlTableSql, this.fieldIde);
        StringBuilder tableAndColumnComment = new StringBuilder();
        if (this.comment != null) {
            sqls.add("COMMENT = '" + this.comment + "'");
            tableAndColumnComment.append(String.format("EXEC %s.sys.sp_addextendedproperty 'MS_Description', N'%s', 'schema', N'%s', 'table', N'%s';\n", tablePath.getDatabaseName(), this.comment, tablePath.getSchemaName(), tablePath.getTableName()));
        }
        String columnComment = "EXEC %s.sys.sp_addextendedproperty 'MS_Description', N'%s', 'schema', N'%s', 'table', N'%s', 'column', N'%s';\n";
        columnComments.forEach((fieldName, com) -> tableAndColumnComment.append(String.format(columnComment, tablePath.getDatabaseName(), com, tablePath.getSchemaName(), tablePath.getTableName(), fieldName)));
        return String.join((CharSequence)"\n", sqlTableSql, tableAndColumnComment.toString(), "END");
    }

    private String buildColumnsIdentifySql(String catalogName, Map<String, String> columnComments) {
        ArrayList<String> columnSqls = new ArrayList<String>();
        for (Column column : this.columns) {
            columnSqls.add("\t" + this.buildColumnIdentifySql(column, catalogName, columnComments));
        }
        if (this.primaryKey != null) {
            columnSqls.add("\t" + this.buildPrimaryKeySql());
        }
        if (CollectionUtils.isNotEmpty(this.constraintKeys)) {
            for (ConstraintKey constraintKey : this.constraintKeys) {
                if (!StringUtils.isBlank((CharSequence)constraintKey.getConstraintName())) continue;
            }
        }
        return String.join((CharSequence)", \n", columnSqls);
    }

    private String buildColumnIdentifySql(Column column, String catalogName, Map<String, String> columnComments) {
        ArrayList<String> columnSqls = new ArrayList<String>();
        columnSqls.add("[" + column.getName() + "]");
        if (StringUtils.equals((CharSequence)catalogName, (CharSequence)"SqlServer")) {
            columnSqls.add(column.getSourceType());
        } else {
            columnSqls.add(SqlServerTypeConverter.INSTANCE.reconvert(column).getColumnType());
        }
        if (column.isNullable()) {
            columnSqls.add("NULL");
        } else {
            columnSqls.add("NOT NULL");
        }
        if (column.getComment() != null) {
            columnComments.put(column.getName(), column.getComment().replace("'", "''"));
        }
        return String.join((CharSequence)" ", columnSqls);
    }

    private String buildPrimaryKeySql() {
        String key = this.primaryKey.getColumnNames().stream().map(columnName -> "[" + columnName + "]").collect(Collectors.joining(", "));
        return String.format("PRIMARY KEY (%s)", key);
    }

    private String buildConstraintKeySql(ConstraintKey constraintKey) {
        ConstraintKey.ConstraintType constraintType = constraintKey.getConstraintType();
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> {
            if (constraintKeyColumn.getSortType() == null) {
                return String.format("`%s`", constraintKeyColumn.getColumnName());
            }
            return String.format("`%s` %s", constraintKeyColumn.getColumnName(), constraintKeyColumn.getSortType().name());
        }).collect(Collectors.joining(", "));
        String keyName = null;
        switch (constraintType) {
            case INDEX_KEY: {
                keyName = "KEY";
                break;
            }
            case UNIQUE_KEY: {
                keyName = "UNIQUE KEY";
                break;
            }
            case FOREIGN_KEY: {
                keyName = "FOREIGN KEY";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported constraint type: " + constraintType);
            }
        }
        return String.format("%s `%s` (%s)", keyName, constraintKey.getConstraintName(), indexColumns);
    }
}

