/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.JdbcColumnConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogUtils {
    private static final Logger log = LoggerFactory.getLogger(CatalogUtils.class);

    public static String getFieldIde(String identifier, String fieldIde) {
        if (StringUtils.isBlank((CharSequence)fieldIde)) {
            return identifier;
        }
        switch (FieldIdeEnum.valueOf(fieldIde.toUpperCase())) {
            case LOWERCASE: {
                return identifier.toLowerCase();
            }
            case UPPERCASE: {
                return identifier.toUpperCase();
            }
        }
        return identifier;
    }

    public static String quoteIdentifier(String identifier, String fieldIde, String quote) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append(quote).append(parts[i]).append(quote).append(".");
            }
            return sb.append(quote).append(CatalogUtils.getFieldIde(parts[parts.length - 1], fieldIde)).append(quote).toString();
        }
        return quote + CatalogUtils.getFieldIde(identifier, fieldIde) + quote;
    }

    public static String quoteIdentifier(String identifier, String fieldIde) {
        return CatalogUtils.getFieldIde(identifier, fieldIde);
    }

    public static String quoteTableIdentifier(String identifier, String fieldIde) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append(parts[i]).append(".");
            }
            return sb.append(CatalogUtils.getFieldIde(parts[parts.length - 1], fieldIde)).toString();
        }
        return CatalogUtils.getFieldIde(identifier, fieldIde);
    }

    public static Optional<PrimaryKey> getPrimaryKey(DatabaseMetaData metaData, TablePath tablePath) throws SQLException {
        ResultSet rs = metaData.getPrimaryKeys(tablePath.getDatabaseName(), tablePath.getSchemaName(), tablePath.getTableName());
        ArrayList<Pair> primaryKeyColumns = new ArrayList<Pair>();
        String pkName = null;
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            pkName = CatalogUtils.cleanKeyName(rs.getString("PK_NAME"));
            int keySeq = rs.getInt("KEY_SEQ");
            primaryKeyColumns.add(Pair.of((Object)keySeq, (Object)columnName));
        }
        List pkFields = primaryKeyColumns.stream().sorted(Comparator.comparingInt(Pair::getKey)).map(Pair::getValue).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pkFields)) {
            return Optional.empty();
        }
        return Optional.of(PrimaryKey.of((String)pkName, pkFields));
    }

    public static List<ConstraintKey> getConstraintKeys(DatabaseMetaData metadata, TablePath tablePath) throws SQLException {
        ResultSet resultSet = metadata.getIndexInfo(tablePath.getDatabaseName(), tablePath.getSchemaName(), tablePath.getTableName(), false, true);
        HashMap<String, ConstraintKey> constraintKeyMap = new HashMap<String, ConstraintKey>();
        while (resultSet.next()) {
            String columnName = resultSet.getString("COLUMN_NAME");
            if (columnName == null) continue;
            String indexName = CatalogUtils.cleanKeyName(resultSet.getString("INDEX_NAME"));
            boolean noUnique = resultSet.getBoolean("NON_UNIQUE");
            ConstraintKey constraintKey = constraintKeyMap.computeIfAbsent(indexName, s -> {
                ConstraintKey.ConstraintType constraintType = ConstraintKey.ConstraintType.INDEX_KEY;
                if (!noUnique) {
                    constraintType = ConstraintKey.ConstraintType.UNIQUE_KEY;
                }
                return ConstraintKey.of((ConstraintKey.ConstraintType)constraintType, (String)indexName, new ArrayList());
            });
            ConstraintKey.ColumnSortType sortType = "A".equals(resultSet.getString("ASC_OR_DESC")) ? ConstraintKey.ColumnSortType.ASC : ConstraintKey.ColumnSortType.DESC;
            ConstraintKey.ConstraintKeyColumn constraintKeyColumn = new ConstraintKey.ConstraintKeyColumn(columnName, sortType);
            constraintKey.getColumnNames().add(constraintKeyColumn);
        }
        return new ArrayList<ConstraintKey>(constraintKeyMap.values());
    }

    private static String cleanKeyName(String keyName) {
        if (keyName != null) {
            keyName = keyName.replaceAll("[^a-zA-Z0-9_]", "");
            keyName = keyName.replaceAll("^_+", "");
        }
        return keyName;
    }

    public static TableSchema getTableSchema(DatabaseMetaData metadata, TablePath tablePath, JdbcDialectTypeMapper typeMapper) throws SQLException {
        List<Column> columns;
        Optional<PrimaryKey> primaryKey = CatalogUtils.getPrimaryKey(metadata, tablePath);
        List<ConstraintKey> constraintKeys = CatalogUtils.getConstraintKeys(metadata, tablePath);
        try {
            columns = typeMapper.mappingColumn(metadata, tablePath.getDatabaseName(), tablePath.getSchemaName(), tablePath.getTableName(), null);
        }
        catch (UnsupportedOperationException e) {
            columns = JdbcColumnConverter.convert(metadata, tablePath);
        }
        return TableSchema.builder().primaryKey((PrimaryKey)primaryKey.orElse(null)).constraintKey(constraintKeys).columns(columns).build();
    }

    public static CatalogTable getCatalogTable(Connection connection, TablePath tablePath, JdbcDialectTypeMapper typeMapper) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        TableSchema tableSchema = CatalogUtils.getTableSchema(metadata, tablePath, typeMapper);
        String catalogName = "jdbc_catalog";
        return CatalogTable.of((TableIdentifier)TableIdentifier.of((String)catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getSchemaName(), (String)tablePath.getTableName()), (TableSchema)tableSchema, new HashMap(), new ArrayList(), (String)"", (String)catalogName);
    }

    public static CatalogTable getCatalogTable(ResultSetMetaData resultSetMetaData, String sqlQuery) throws SQLException {
        return CatalogUtils.getCatalogTable(resultSetMetaData, (ResultSetMetaData metadata, Integer index) -> {
            try {
                return JdbcColumnConverter.convert(metadata, index);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }, sqlQuery);
    }

    public static CatalogTable getCatalogTable(ResultSetMetaData metadata, JdbcDialectTypeMapper typeMapper, String sqlQuery) throws SQLException {
        return CatalogUtils.getCatalogTable(metadata, (ResultSetMetaData resultSetMetaData, Integer index) -> {
            try {
                return typeMapper.mappingColumn((ResultSetMetaData)resultSetMetaData, (int)index);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }, sqlQuery);
    }

    public static CatalogTable getCatalogTable(ResultSetMetaData metadata, BiFunction<ResultSetMetaData, Integer, Column> columnConverter, String sqlQuery) throws SQLException {
        TableSchema.Builder schemaBuilder = TableSchema.builder();
        LinkedHashMap<String, String> unsupported = new LinkedHashMap<String, String>();
        for (int index = 1; index <= metadata.getColumnCount(); ++index) {
            try {
                Column column = columnConverter.apply(metadata, index);
                schemaBuilder.column(column);
                continue;
            }
            catch (SeaTunnelRuntimeException e) {
                if (e.getSeaTunnelErrorCode().equals(CommonErrorCode.CONVERT_TO_SEATUNNEL_TYPE_ERROR_SIMPLE)) {
                    unsupported.put((String)e.getParams().get("field"), (String)e.getParams().get("dataType"));
                    continue;
                }
                throw e;
            }
        }
        if (!unsupported.isEmpty()) {
            throw CommonError.getCatalogTableWithUnsupportedType((String)"UNKNOWN", (String)sqlQuery, unsupported);
        }
        String catalogName = "jdbc_catalog";
        return CatalogTable.of((TableIdentifier)TableIdentifier.of((String)catalogName, (String)"default", (String)"default", (String)"default"), (TableSchema)schemaBuilder.build(), new HashMap(), new ArrayList(), (String)"", (String)catalogName);
    }

    public static CatalogTable getCatalogTable(Connection connection, String sqlQuery, JdbcDialectTypeMapper typeMapper) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement(sqlQuery);){
            CatalogTable catalogTable = CatalogUtils.getCatalogTable(ps.getMetaData(), typeMapper, sqlQuery);
            return catalogTable;
        }
    }

    @Deprecated
    public static CatalogTable getCatalogTable(Connection connection, String sqlQuery) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement(sqlQuery);){
            ResultSetMetaData resultSetMetaData = ps.getMetaData();
            CatalogTable catalogTable = CatalogUtils.getCatalogTable(resultSetMetaData, sqlQuery);
            return catalogTable;
        }
    }
}

