/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.xugu;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.xugu.XuguJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.xugu.XuguTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;

public class XuguDialect
implements JdbcDialect {
    private static final int DEFAULT_XUGU_FETCH_SIZE = 500;
    public String fieldIde = FieldIdeEnum.ORIGINAL.getValue();

    public XuguDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    public XuguDialect() {
    }

    @Override
    public String dialectName() {
        return "XUGU";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new XuguJdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new XuguTypeMapper();
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("\"").append(parts[i]).append("\"").append(".");
            }
            return sb.append("\"").append(this.getFieldIde(parts[parts.length - 1], this.fieldIde)).append("\"").toString();
        }
        return "\"" + this.getFieldIde(identifier, this.fieldIde) + "\"";
    }

    @Override
    public String tableIdentifier(String database, String tableName) {
        return this.quoteIdentifier(tableName);
    }

    @Override
    public String extractTableName(TablePath tablePath) {
        return tablePath.getSchemaAndTableName();
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)true);
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return this.quoteIdentifier(tablePath.getSchemaAndTableName());
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(fieldName -> !Arrays.asList(uniqueKeyFields).contains(fieldName)).collect(Collectors.toList());
        String valuesBinding = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName + " " + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s FROM DUAL", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(fieldName -> "SOURCE." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String upsertSQL = String.format(" MERGE INTO %s TARGET USING (%s) SOURCE ON (%s)  WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s)", this.tableIdentifier(database, tableName), usingClause, onConditions, updateSetClause, insertFields, insertValues);
        return Optional.of(upsertSQL);
    }

    @Override
    public PreparedStatement creatPreparedStatement(Connection connection, String queryTemplate, int fetchSize) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(queryTemplate, 1003, 1007);
        if (fetchSize > 0) {
            statement.setFetchSize(fetchSize);
        } else {
            statement.setFetchSize(500);
        }
        return statement;
    }

    @Override
    public Object queryNextChunkMax(Connection connection, JdbcSourceTable table, String columnName, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = this.quoteIdentifier(columnName);
        String sqlQuery = StringUtils.isNotBlank((CharSequence)table.getQuery()) ? String.format("SELECT MAX(%s) FROM (SELECT %s FROM (%s) WHERE %s >= ? ORDER BY %s ASC ) WHERE ROWNUM <= %s", quotedColumn, quotedColumn, table.getQuery(), quotedColumn, quotedColumn, chunkSize) : String.format("SELECT MAX(%s) FROM (SELECT %s FROM %s WHERE %s >= ? ORDER BY %s ASC ) WHERE ROWNUM <= %s", quotedColumn, quotedColumn, table.getTablePath().getSchemaAndTableName(), quotedColumn, quotedColumn, chunkSize);
        try (PreparedStatement ps = connection.prepareStatement(sqlQuery);){
            Object object;
            block13: {
                ps.setObject(1, includedLowerBound);
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new SQLException(String.format("No result returned after running query [%s]", sqlQuery));
                    }
                    object = rs.getObject(1);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return object;
        }
    }

    @Override
    public ResultSetMetaData getResultSetMetaData(Connection conn, String query) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(query);
        return ps.executeQuery().getMetaData();
    }
}

