/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mysql.cj.MysqlType;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql.MySqlTypeConverter;

@Deprecated
@AutoService(value={DataTypeConvertor.class})
public class MysqlDataTypeConvertor
implements DataTypeConvertor<MysqlType> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 10;
    public static final Integer DEFAULT_SCALE = 0;

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String connectorDataType) {
        ImmutableMap dataTypeProperties;
        Preconditions.checkNotNull((Object)connectorDataType, (Object)"connectorDataType can not be null");
        MysqlType mysqlType = MysqlType.getByName((String)connectorDataType);
        switch (mysqlType) {
            case BIGINT_UNSIGNED: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: 
            case BIT: {
                int left = connectorDataType.indexOf("(");
                int right = connectorDataType.indexOf(")");
                int precision = DEFAULT_PRECISION;
                int scale = DEFAULT_SCALE;
                if (left != -1 && right != -1) {
                    String[] precisionAndScale = connectorDataType.substring(left + 1, right).split(",");
                    if (precisionAndScale.length == 2) {
                        precision = Integer.parseInt(precisionAndScale[0]);
                        scale = Integer.parseInt(precisionAndScale[1]);
                    } else if (precisionAndScale.length == 1) {
                        precision = Integer.parseInt(precisionAndScale[0]);
                    }
                }
                dataTypeProperties = ImmutableMap.of((Object)PRECISION, (Object)precision, (Object)SCALE, (Object)scale);
                break;
            }
            default: {
                dataTypeProperties = Collections.emptyMap();
            }
        }
        return this.toSeaTunnelType(field, mysqlType, (Map<String, Object>)dataTypeProperties);
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field, MysqlType mysqlType, Map<String, Object> dataTypeProperties) {
        Preconditions.checkNotNull((Object)mysqlType, (Object)"mysqlType can not be null");
        Long precision = MapUtils.getLong(dataTypeProperties, (Object)PRECISION);
        Integer scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE);
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(field).nativeType((Object)mysqlType).dataType(mysqlType.getName()).columnType(mysqlType.getName()).length(precision).precision(precision).scale(scale).build();
        return MySqlTypeConverter.DEFAULT_INSTANCE.convert(typeDefine).getDataType();
    }

    public MysqlType toConnectorType(String field, SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) {
        Long precision = MapUtils.getLong(dataTypeProperties, (Object)PRECISION);
        Integer scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE);
        PhysicalColumn column = PhysicalColumn.builder().name(field).dataType(seaTunnelDataType).columnLength(precision).scale(scale).nullable(true).build();
        BasicTypeDefine<MysqlType> typeDefine = MySqlTypeConverter.DEFAULT_INSTANCE.reconvert((Column)column);
        return (MysqlType)typeDefine.getNativeType();
    }

    public String getIdentity() {
        return "MySQL";
    }
}

