/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oceanbase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oceanbase.OceanBaseMySqlTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oceanbase.OceanBaseMysqlType;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class OceanBaseMysqlCreateTableSqlBuilder {
    private final String tableName;
    private List<Column> columns;
    private String comment;
    private String engine;
    private String charset;
    private String collate;
    private PrimaryKey primaryKey;
    private List<ConstraintKey> constraintKeys;
    private String fieldIde;
    private final OceanBaseMySqlTypeConverter typeConverter;
    private boolean createIndex;

    private OceanBaseMysqlCreateTableSqlBuilder(String tableName, OceanBaseMySqlTypeConverter typeConverter, boolean createIndex) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName must not be null");
        this.tableName = tableName;
        this.typeConverter = typeConverter;
        this.createIndex = createIndex;
    }

    public static OceanBaseMysqlCreateTableSqlBuilder builder(TablePath tablePath, CatalogTable catalogTable, OceanBaseMySqlTypeConverter typeConverter, boolean createIndex) {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath must not be null");
        Preconditions.checkNotNull((Object)catalogTable, (Object)"catalogTable must not be null");
        TableSchema tableSchema = catalogTable.getTableSchema();
        Preconditions.checkNotNull((Object)tableSchema, (Object)"tableSchema must not be null");
        return new OceanBaseMysqlCreateTableSqlBuilder(tablePath.getTableName(), typeConverter, createIndex).comment(catalogTable.getComment()).engine(null).charset(null).primaryKey(tableSchema.getPrimaryKey()).constraintKeys(tableSchema.getConstraintKeys()).addColumn(tableSchema.getColumns()).fieldIde((String)catalogTable.getOptions().get("fieldIde"));
    }

    public OceanBaseMysqlCreateTableSqlBuilder addColumn(List<Column> columns) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columns), (Object)"columns must not be empty");
        this.columns = columns;
        return this;
    }

    public OceanBaseMysqlCreateTableSqlBuilder primaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public OceanBaseMysqlCreateTableSqlBuilder fieldIde(String fieldIde) {
        this.fieldIde = fieldIde;
        return this;
    }

    public OceanBaseMysqlCreateTableSqlBuilder constraintKeys(List<ConstraintKey> constraintKeys) {
        this.constraintKeys = constraintKeys;
        return this;
    }

    public OceanBaseMysqlCreateTableSqlBuilder engine(String engine) {
        this.engine = engine;
        return this;
    }

    public OceanBaseMysqlCreateTableSqlBuilder charset(String charset) {
        this.charset = charset;
        return this;
    }

    public OceanBaseMysqlCreateTableSqlBuilder collate(String collate) {
        this.collate = collate;
        return this;
    }

    public OceanBaseMysqlCreateTableSqlBuilder comment(String comment) {
        this.comment = comment;
        return this;
    }

    public String build(String catalogName) {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(String.format("CREATE TABLE %s (\n%s\n)", CatalogUtils.quoteIdentifier(this.tableName, this.fieldIde, "`"), this.buildColumnsIdentifySql(catalogName)));
        if (this.engine != null) {
            sqls.add("ENGINE = " + this.engine);
        }
        if (this.charset != null) {
            sqls.add("DEFAULT CHARSET = " + this.charset);
        }
        if (this.collate != null) {
            sqls.add("COLLATE = " + this.collate);
        }
        if (this.comment != null) {
            sqls.add("COMMENT = '" + this.comment + "'");
        }
        return String.join((CharSequence)" ", sqls) + ";";
    }

    private String buildColumnsIdentifySql(String catalogName) {
        ArrayList<String> columnSqls = new ArrayList<String>();
        HashMap<String, String> columnTypeMap = new HashMap<String, String>();
        for (Column column : this.columns) {
            columnSqls.add("\t" + this.buildColumnIdentifySql(column, catalogName, columnTypeMap));
        }
        if (this.createIndex && this.primaryKey != null) {
            columnSqls.add("\t" + this.buildPrimaryKeySql());
        }
        if (this.createIndex && CollectionUtils.isNotEmpty(this.constraintKeys)) {
            for (ConstraintKey constraintKey : this.constraintKeys) {
                String constraintKeyStr;
                if (StringUtils.isBlank((CharSequence)constraintKey.getConstraintName()) || !StringUtils.isNotBlank((CharSequence)(constraintKeyStr = this.buildConstraintKeySql(constraintKey, columnTypeMap)))) continue;
                columnSqls.add("\t" + constraintKeyStr);
            }
        }
        return String.join((CharSequence)", \n", columnSqls);
    }

    private String buildColumnIdentifySql(Column column, String catalogName, Map<String, String> columnTypeMap) {
        String type;
        ArrayList<String> columnSqls = new ArrayList<String>();
        columnSqls.add(CatalogUtils.quoteIdentifier(column.getName(), this.fieldIde, "`"));
        if ((SqlType.TIME.equals((Object)column.getDataType().getSqlType()) || SqlType.TIMESTAMP.equals((Object)column.getDataType().getSqlType())) && column.getScale() != null) {
            BasicTypeDefine<OceanBaseMysqlType> typeDefine = this.typeConverter.reconvert(column);
            type = typeDefine.getColumnType();
        } else if (StringUtils.equals((CharSequence)catalogName, (CharSequence)"MySQL") && StringUtils.isNotBlank((CharSequence)column.getSourceType())) {
            type = column.getSourceType();
        } else {
            BasicTypeDefine<OceanBaseMysqlType> typeDefine = this.typeConverter.reconvert(column);
            type = typeDefine.getColumnType();
        }
        columnSqls.add(type);
        columnTypeMap.put(column.getName(), type);
        if (column.isNullable()) {
            columnSqls.add("NULL");
        } else {
            columnSqls.add("NOT NULL");
        }
        if (column.getComment() != null) {
            columnSqls.add("COMMENT '" + column.getComment().replace("'", "''").replace("\\", "\\\\") + "'");
        }
        return String.join((CharSequence)" ", columnSqls);
    }

    private String buildPrimaryKeySql() {
        String key = this.primaryKey.getColumnNames().stream().map(columnName -> "`" + columnName + "`").collect(Collectors.joining(", "));
        return String.format("PRIMARY KEY (%s)", CatalogUtils.quoteIdentifier(key, this.fieldIde));
    }

    private String buildConstraintKeySql(ConstraintKey constraintKey, Map<String, String> columnTypeMap) {
        ConstraintKey.ConstraintType constraintType = constraintKey.getConstraintType();
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> {
            String columnType;
            String columnName = constraintKeyColumn.getColumnName();
            boolean withLength = false;
            if (columnTypeMap.containsKey(columnName) && ((columnType = (String)columnTypeMap.get(columnName)).endsWith("BLOB") || columnType.endsWith("TEXT"))) {
                withLength = true;
            }
            if (constraintKeyColumn.getSortType() == null) {
                return String.format("`%s`%s", CatalogUtils.getFieldIde(columnName, this.fieldIde), withLength ? "(255)" : "");
            }
            return String.format("`%s`%s %s", CatalogUtils.getFieldIde(columnName, this.fieldIde), withLength ? "(255)" : "", constraintKeyColumn.getSortType().name());
        }).collect(Collectors.joining(", "));
        String keyName = null;
        switch (constraintType) {
            case INDEX_KEY: {
                keyName = "KEY";
                break;
            }
            case UNIQUE_KEY: {
                keyName = "UNIQUE KEY";
                break;
            }
            case FOREIGN_KEY: {
                keyName = "FOREIGN KEY";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported constraint type: " + constraintType);
            }
        }
        return String.format("%s `%s` (%s)", keyName, constraintKey.getConstraintName(), indexColumns);
    }
}

