/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.redshift;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.redshift.RedshiftTypeConverter;

public class RedshiftCreateTableSqlBuilder {
    private List<Column> columns;
    private PrimaryKey primaryKey;
    private String sourceCatalogName;
    private boolean createIndex;

    public RedshiftCreateTableSqlBuilder(CatalogTable catalogTable, boolean createIndex) {
        this.columns = catalogTable.getTableSchema().getColumns();
        this.primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        this.sourceCatalogName = catalogTable.getCatalogName();
        this.createIndex = createIndex;
    }

    public String build(TablePath tablePath) {
        return this.build(tablePath, "");
    }

    public String build(TablePath tablePath, String fieldIde) {
        StringBuilder createTableSql = new StringBuilder();
        createTableSql.append(CatalogUtils.quoteIdentifier("CREATE TABLE ", fieldIde)).append(tablePath.getSchemaAndTableName("\"")).append(" (\n");
        List columnSqls = this.columns.stream().map(column -> CatalogUtils.quoteIdentifier(this.buildColumnSql((Column)column), fieldIde)).collect(Collectors.toList());
        if (this.createIndex && this.primaryKey != null && this.primaryKey.getColumnNames().size() > 1) {
            columnSqls.add(CatalogUtils.quoteIdentifier("PRIMARY KEY (" + this.primaryKey.getColumnNames().stream().map(column -> "\"" + column + "\"").collect(Collectors.joining(",")) + ")", fieldIde));
        }
        createTableSql.append(String.join((CharSequence)",\n", columnSqls));
        createTableSql.append("\n);");
        List commentSqls = this.columns.stream().filter(column -> StringUtils.isNotBlank((CharSequence)column.getComment())).map(columns -> this.buildColumnCommentSql((Column)columns, tablePath.getSchemaAndTableName("\""), fieldIde)).collect(Collectors.toList());
        if (!commentSqls.isEmpty()) {
            createTableSql.append("\n");
            createTableSql.append(String.join((CharSequence)";\n", commentSqls)).append(";");
        }
        return createTableSql.toString();
    }

    private String buildColumnSql(Column column) {
        StringBuilder columnSql = new StringBuilder();
        columnSql.append("\"").append(column.getName()).append("\" ");
        String columnType = (StringUtils.equals((CharSequence)this.sourceCatalogName, (CharSequence)"Redshift") || StringUtils.equals((CharSequence)this.sourceCatalogName, (CharSequence)"Postgres")) && StringUtils.isNotBlank((CharSequence)column.getSourceType()) ? column.getSourceType() : RedshiftTypeConverter.INSTANCE.reconvert(column).getColumnType();
        columnSql.append(columnType);
        if (!column.isNullable()) {
            columnSql.append(" NOT NULL");
        }
        if (this.createIndex && this.primaryKey != null && this.primaryKey.getColumnNames().contains(column.getName()) && this.primaryKey.getColumnNames().size() == 1) {
            columnSql.append(" PRIMARY KEY");
        }
        return columnSql.toString();
    }

    private String buildColumnCommentSql(Column column, String tableName, String fieldIde) {
        StringBuilder columnCommentSql = new StringBuilder();
        columnCommentSql.append(CatalogUtils.quoteIdentifier("COMMENT ON COLUMN ", fieldIde)).append(tableName).append(".");
        columnCommentSql.append(CatalogUtils.quoteIdentifier(column.getName(), fieldIde, "\"")).append(CatalogUtils.quoteIdentifier(" IS '", fieldIde)).append(column.getComment()).append("'");
        return columnCommentSql.toString();
    }
}

