/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.redshift;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.redshift.RedshiftTypeConverter;

@Deprecated
@AutoService(value={DataTypeConvertor.class})
public class RedshiftDataTypeConvertor
implements DataTypeConvertor<String> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 10;
    public static final Integer DEFAULT_SCALE = 0;

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String connectorDataType) {
        return this.toSeaTunnelType(field, connectorDataType, Collections.emptyMap());
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String connectorDataType, Map<String, Object> dataTypeProperties) {
        Preconditions.checkNotNull((Object)connectorDataType, (Object)"redshiftType cannot be null");
        Integer precision = null;
        Integer scale = null;
        switch (connectorDataType.toUpperCase()) {
            case "numeric": {
                precision = MapUtils.getInteger(dataTypeProperties, (Object)PRECISION, (Integer)DEFAULT_PRECISION);
                scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE, (Integer)DEFAULT_SCALE);
                break;
            }
        }
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(field).columnType(connectorDataType).dataType(connectorDataType).length(precision == null ? null : Long.valueOf(precision.intValue())).precision(precision == null ? null : Long.valueOf(precision.intValue())).scale(scale).build();
        return RedshiftTypeConverter.INSTANCE.convert(typeDefine).getDataType();
    }

    public String toConnectorType(String field, SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) {
        Preconditions.checkNotNull(seaTunnelDataType, (Object)"seaTunnelDataType cannot be null");
        Long precision = MapUtils.getLong(dataTypeProperties, (Object)PRECISION);
        Integer scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE);
        PhysicalColumn column = PhysicalColumn.builder().name(field).dataType(seaTunnelDataType).columnLength(precision).scale(scale).nullable(true).build();
        BasicTypeDefine typeDefine = RedshiftTypeConverter.INSTANCE.reconvert((Column)column);
        return typeDefine.getColumnType();
    }

    public String getIdentity() {
        return "Redshift";
    }
}

