/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.SQLUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDialect
implements JdbcDialect {
    private static final Logger log = LoggerFactory.getLogger(OracleDialect.class);
    private static final int DEFAULT_ORACLE_FETCH_SIZE = 128;
    public String fieldIde = FieldIdeEnum.ORIGINAL.getValue();

    public OracleDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    public OracleDialect() {
    }

    @Override
    public String dialectName() {
        return "Oracle";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new OracleJdbcRowConverter();
    }

    @Override
    public String hashModForField(String fieldName, int mod) {
        return "MOD(ORA_HASH(" + this.quoteIdentifier(fieldName) + ")," + mod + ")";
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new OracleTypeMapper();
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("\"").append(parts[i]).append("\"").append(".");
            }
            return sb.append("\"").append(this.getFieldIde(parts[parts.length - 1], this.fieldIde)).append("\"").toString();
        }
        return "\"" + this.getFieldIde(identifier, this.fieldIde) + "\"";
    }

    @Override
    public String tableIdentifier(String database, String tableName) {
        return this.quoteIdentifier(tableName);
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(fieldName -> !Arrays.asList(uniqueKeyFields).contains(fieldName)).collect(Collectors.toList());
        String valuesBinding = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName + " " + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s FROM DUAL", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(fieldName -> "SOURCE." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String upsertSQL = String.format(" MERGE INTO %s TARGET USING (%s) SOURCE ON (%s)  WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s)", this.tableIdentifier(database, tableName), usingClause, onConditions, updateSetClause, insertFields, insertValues);
        return Optional.of(upsertSQL);
    }

    @Override
    public PreparedStatement creatPreparedStatement(Connection connection, String queryTemplate, int fetchSize) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(queryTemplate, 1003, 1007);
        if (fetchSize > 0) {
            statement.setFetchSize(fetchSize);
        } else {
            statement.setFetchSize(128);
        }
        return statement;
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)true);
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return this.quoteIdentifier(tablePath.getSchemaAndTableName());
    }

    @Override
    public Long approximateRowCntStatement(Connection connection, JdbcSourceTable table) throws SQLException {
        boolean useTableStats;
        String query = table.getQuery();
        boolean bl = useTableStats = StringUtils.isBlank((CharSequence)query) || !query.toLowerCase().contains("where") && table.getTablePath() != null && !TablePath.DEFAULT.getFullName().equals(table.getTablePath().getFullName());
        if (table.getUseSelectCount().booleanValue()) {
            useTableStats = false;
            if (StringUtils.isBlank((CharSequence)query)) {
                query = "SELECT * FROM " + this.tableIdentifier(table.getTablePath());
            }
        }
        if (useTableStats) {
            TablePath tablePath = table.getTablePath();
            String rowCountQuery = String.format("select NUM_ROWS from all_tables where OWNER = '%s' AND TABLE_NAME = '%s' ", tablePath.getSchemaName(), tablePath.getTableName());
            try (Statement stmt = connection.createStatement();){
                Long l;
                block18: {
                    String analyzeTable = String.format("analyze table %s compute statistics for table", this.tableIdentifier(tablePath));
                    if (!table.getSkipAnalyze().booleanValue()) {
                        log.info("Split Chunk, approximateRowCntStatement: {}", (Object)analyzeTable);
                        stmt.execute(analyzeTable);
                    } else {
                        log.warn("Skip analyze, approximateRowCntStatement: {}", (Object)analyzeTable);
                    }
                    log.info("Split Chunk, approximateRowCntStatement: {}", (Object)rowCountQuery);
                    ResultSet rs = stmt.executeQuery(rowCountQuery);
                    try {
                        if (!rs.next()) {
                            throw new SQLException(String.format("No result returned after running query [%s]", rowCountQuery));
                        }
                        l = rs.getLong(1);
                        if (rs == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return l;
            }
        }
        return SQLUtils.countForSubquery(connection, query);
    }

    @Override
    public Object queryNextChunkMax(Connection connection, JdbcSourceTable table, String columnName, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = this.quoteIdentifier(columnName);
        String sqlQuery = StringUtils.isNotBlank((CharSequence)table.getQuery()) ? String.format("SELECT MAX(%s) FROM (SELECT %s FROM (%s) WHERE %s >= ? ORDER BY %s ASC ) WHERE ROWNUM <= %s", quotedColumn, quotedColumn, table.getQuery(), quotedColumn, quotedColumn, chunkSize) : String.format("SELECT MAX(%s) FROM (SELECT %s FROM %s WHERE %s >= ? ORDER BY %s ASC ) WHERE ROWNUM <= %s", quotedColumn, quotedColumn, this.tableIdentifier(table.getTablePath()), quotedColumn, quotedColumn, chunkSize);
        try (PreparedStatement ps = connection.prepareStatement(sqlQuery);){
            Object object;
            block13: {
                ps.setObject(1, includedLowerBound);
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new SQLException(String.format("No result returned after running query [%s]", sqlQuery));
                    }
                    object = rs.getObject(1);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return object;
        }
    }

    @Override
    public Object[] sampleDataFromColumn(Connection connection, JdbcSourceTable table, String columnName, int samplingRate, int fetchSize) throws Exception {
        String sampleQuery = StringUtils.isNotBlank((CharSequence)table.getQuery()) ? String.format("SELECT %s FROM (%s) T", this.quoteIdentifier(columnName), table.getQuery()) : String.format("SELECT %s FROM %s", this.quoteIdentifier(columnName), this.tableIdentifier(table.getTablePath()));
        try (PreparedStatement stmt = this.creatPreparedStatement(connection, sampleQuery, fetchSize);){
            Object[] objectArray;
            block14: {
                ResultSet rs = stmt.executeQuery();
                try {
                    int count = 0;
                    ArrayList<Object> results = new ArrayList<Object>();
                    while (rs.next()) {
                        if (++count % samplingRate == 0) {
                            results.add(rs.getObject(1));
                        }
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException("Thread interrupted");
                    }
                    Object[] resultsArray = results.toArray();
                    Arrays.sort(resultsArray);
                    objectArray = resultsArray;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return objectArray;
        }
    }
}

