/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.utils;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceTableConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCatalogUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcCatalogUtils.class);
    private static final String DEFAULT_CATALOG_NAME = "jdbc_catalog";

    public static Map<TablePath, JdbcSourceTable> getTables(JdbcConnectionConfig jdbcConnectionConfig, List<JdbcSourceTableConfig> tablesConfig) throws SQLException, ClassNotFoundException {
        LinkedHashMap<TablePath, JdbcSourceTable> tables = new LinkedHashMap<TablePath, JdbcSourceTable>();
        JdbcDialect jdbcDialect = JdbcDialectLoader.load(jdbcConnectionConfig.getUrl(), jdbcConnectionConfig.getCompatibleMode());
        Optional<Catalog> catalog = JdbcCatalogUtils.findCatalog(jdbcConnectionConfig, jdbcDialect);
        if (catalog.isPresent()) {
            try (AbstractJdbcCatalog jdbcCatalog = (AbstractJdbcCatalog)catalog.get();){
                log.info("Loading catalog tables for catalog : {}", jdbcCatalog.getClass());
                jdbcCatalog.open();
                LinkedHashMap<String, Map> unsupportedTable = new LinkedHashMap<String, Map>();
                for (JdbcSourceTableConfig tableConfig : tablesConfig) {
                    try {
                        CatalogTable catalogTable = JdbcCatalogUtils.getCatalogTable(tableConfig, jdbcCatalog, jdbcDialect);
                        TablePath tablePath = catalogTable.getTableId().toTablePath();
                        JdbcSourceTable jdbcSourceTable = JdbcSourceTable.builder().tablePath(tablePath).query(tableConfig.getQuery()).partitionColumn(tableConfig.getPartitionColumn()).partitionNumber(tableConfig.getPartitionNumber()).partitionStart(tableConfig.getPartitionStart()).partitionEnd(tableConfig.getPartitionEnd()).useSelectCount(tableConfig.getUseSelectCount()).skipAnalyze(tableConfig.getSkipAnalyze()).catalogTable(catalogTable).build();
                        tables.put(tablePath, jdbcSourceTable);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Loaded catalog table : {}, {}", (Object)tablePath, (Object)jdbcSourceTable);
                    }
                    catch (SeaTunnelRuntimeException e) {
                        if (e.getSeaTunnelErrorCode().equals(CommonErrorCode.GET_CATALOG_TABLE_WITH_UNSUPPORTED_TYPE_ERROR)) {
                            unsupportedTable.put((String)e.getParams().get("tableName"), e.getParamsValueAsMap("fieldWithDataTypes"));
                            continue;
                        }
                        throw e;
                    }
                }
                if (!unsupportedTable.isEmpty()) {
                    throw CommonError.getCatalogTablesWithUnsupportedType((String)jdbcDialect.dialectName(), unsupportedTable);
                }
                log.info("Loaded {} catalog tables for catalog : {}", (Object)tables.size(), jdbcCatalog.getClass());
            }
            return tables;
        }
        log.warn("Catalog not found, loading tables from jdbc directly. url : {}", (Object)jdbcConnectionConfig.getUrl());
        try (Connection connection = JdbcCatalogUtils.getConnection(jdbcConnectionConfig, jdbcDialect);){
            log.info("Loading catalog tables for jdbc : {}", (Object)jdbcConnectionConfig.getUrl());
            for (JdbcSourceTableConfig tableConfig : tablesConfig) {
                CatalogTable catalogTable = JdbcCatalogUtils.getCatalogTable(tableConfig, connection, jdbcDialect);
                TablePath tablePath = catalogTable.getTableId().toTablePath();
                JdbcSourceTable jdbcSourceTable = JdbcSourceTable.builder().tablePath(tablePath).query(tableConfig.getQuery()).partitionColumn(tableConfig.getPartitionColumn()).partitionNumber(tableConfig.getPartitionNumber()).partitionStart(tableConfig.getPartitionStart()).partitionEnd(tableConfig.getPartitionEnd()).useSelectCount(tableConfig.getUseSelectCount()).skipAnalyze(tableConfig.getSkipAnalyze()).catalogTable(catalogTable).build();
                tables.put(tablePath, jdbcSourceTable);
                if (!log.isDebugEnabled()) continue;
                log.debug("Loaded catalog table : {}, {}", (Object)tablePath, (Object)jdbcSourceTable);
            }
            log.info("Loaded {} catalog tables for jdbc : {}", (Object)tables.size(), (Object)jdbcConnectionConfig.getUrl());
            LinkedHashMap<TablePath, JdbcSourceTable> linkedHashMap = tables;
            return linkedHashMap;
        }
    }

    private static CatalogTable getCatalogTable(JdbcSourceTableConfig tableConfig, AbstractJdbcCatalog jdbcCatalog, JdbcDialect jdbcDialect) throws SQLException {
        if (Strings.isNullOrEmpty((String)tableConfig.getTablePath()) && Strings.isNullOrEmpty((String)tableConfig.getQuery())) {
            throw new IllegalArgumentException("Either table path or query must be specified in source configuration.");
        }
        if (StringUtils.isNotEmpty((CharSequence)tableConfig.getTablePath()) && StringUtils.isNotEmpty((CharSequence)tableConfig.getQuery())) {
            TablePath tablePath = jdbcDialect.parse(tableConfig.getTablePath());
            CatalogTable tableOfPath = null;
            try {
                tableOfPath = jdbcCatalog.getTable(tablePath);
            }
            catch (Exception e) {
                log.debug("User-defined table path: {}", (Object)tablePath);
            }
            CatalogTable tableOfQuery = jdbcCatalog.getTable(tableConfig.getQuery());
            if (tableOfPath == null) {
                String catalogName = tableOfQuery.getTableId() == null ? DEFAULT_CATALOG_NAME : tableOfQuery.getTableId().getCatalogName();
                TableIdentifier tableIdentifier = TableIdentifier.of((String)catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getSchemaName(), (String)tablePath.getTableName());
                return CatalogTable.of((TableIdentifier)tableIdentifier, (CatalogTable)tableOfQuery);
            }
            return JdbcCatalogUtils.mergeCatalogTable(tableOfPath, tableOfQuery);
        }
        if (StringUtils.isNotEmpty((CharSequence)tableConfig.getTablePath())) {
            TablePath tablePath = jdbcDialect.parse(tableConfig.getTablePath());
            return jdbcCatalog.getTable(tablePath);
        }
        return jdbcCatalog.getTable(tableConfig.getQuery());
    }

    static CatalogTable mergeCatalogTable(CatalogTable tableOfPath, CatalogTable tableOfQuery) {
        boolean schemaEquals;
        TableSchema tableSchemaOfPath = tableOfPath.getTableSchema();
        Map columnsOfPath = tableSchemaOfPath.getColumns().stream().collect(Collectors.toMap(Column::getName, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
        TableSchema tableSchemaOfQuery = tableOfQuery.getTableSchema();
        Map columnsOfQuery = tableSchemaOfQuery.getColumns().stream().collect(Collectors.toMap(Column::getName, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
        Set columnKeysOfQuery = columnsOfQuery.keySet();
        List columnsOfMerge = tableSchemaOfQuery.getColumns().stream().filter(column -> columnsOfPath.containsKey(column.getName()) && ((Column)columnsOfPath.get(column.getName())).getDataType().equals(((Column)columnsOfQuery.get(column.getName())).getDataType())).map(column -> (Column)columnsOfPath.get(column.getName())).collect(Collectors.toList());
        boolean schemaIncludeAllColumns = columnsOfMerge.size() == columnKeysOfQuery.size();
        boolean bl = schemaEquals = schemaIncludeAllColumns && columnsOfMerge.size() == columnsOfPath.size();
        if (schemaEquals) {
            return CatalogTable.of((TableIdentifier)tableOfPath.getTableId(), (TableSchema)TableSchema.builder().primaryKey(tableSchemaOfPath.getPrimaryKey()).constraintKey(tableSchemaOfPath.getConstraintKeys()).columns(columnsOfMerge).build(), (Map)tableOfPath.getOptions(), (List)tableOfPath.getPartitionKeys(), (String)tableOfPath.getComment());
        }
        PrimaryKey primaryKeyOfPath = tableSchemaOfPath.getPrimaryKey();
        List constraintKeysOfPath = tableSchemaOfPath.getConstraintKeys();
        List partitionKeysOfPath = tableOfPath.getPartitionKeys();
        PrimaryKey primaryKeyOfMerge = null;
        ArrayList<ConstraintKey> constraintKeysOfMerge = new ArrayList<ConstraintKey>();
        List partitionKeysOfMerge = new ArrayList();
        if (primaryKeyOfPath != null && columnKeysOfQuery.containsAll(primaryKeyOfPath.getColumnNames())) {
            primaryKeyOfMerge = primaryKeyOfPath;
        }
        if (constraintKeysOfPath != null) {
            for (ConstraintKey constraintKey : constraintKeysOfPath) {
                Set constraintKeyFields = constraintKey.getColumnNames().stream().map(e -> e.getColumnName()).collect(Collectors.toSet());
                if (!columnKeysOfQuery.containsAll(constraintKeyFields)) continue;
                constraintKeysOfMerge.add(constraintKey);
            }
        }
        if (partitionKeysOfPath != null && columnKeysOfQuery.containsAll(partitionKeysOfPath)) {
            partitionKeysOfMerge = partitionKeysOfPath;
        }
        if (schemaIncludeAllColumns) {
            return CatalogTable.of((TableIdentifier)tableOfPath.getTableId(), (TableSchema)TableSchema.builder().primaryKey(primaryKeyOfMerge).constraintKey(constraintKeysOfMerge).columns(columnsOfMerge).build(), (Map)tableOfPath.getOptions(), partitionKeysOfMerge, (String)tableOfPath.getComment());
        }
        String catalogName = tableOfQuery.getTableId() == null ? DEFAULT_CATALOG_NAME : tableOfQuery.getTableId().getCatalogName();
        TableIdentifier tableIdentifier = TableIdentifier.of((String)catalogName, (String)tableOfPath.getTableId().getDatabaseName(), (String)tableOfPath.getTableId().getSchemaName(), (String)tableOfPath.getTableId().getTableName());
        CatalogTable mergedCatalogTable = CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)TableSchema.builder().primaryKey(primaryKeyOfMerge).constraintKey(constraintKeysOfMerge).columns(tableSchemaOfQuery.getColumns()).build(), (Map)tableOfPath.getOptions(), partitionKeysOfMerge, (String)tableOfPath.getComment());
        log.info("Merged catalog table of path {}", (Object)tableOfPath.getTableId().toTablePath());
        return mergedCatalogTable;
    }

    private static CatalogTable getCatalogTable(JdbcSourceTableConfig tableConfig, Connection connection, JdbcDialect jdbcDialect) throws SQLException {
        if (Strings.isNullOrEmpty((String)tableConfig.getTablePath()) && Strings.isNullOrEmpty((String)tableConfig.getQuery())) {
            throw new IllegalArgumentException("Either table path or query must be specified in source configuration.");
        }
        if (StringUtils.isNotEmpty((CharSequence)tableConfig.getTablePath()) && StringUtils.isNotEmpty((CharSequence)tableConfig.getQuery())) {
            TablePath tablePath = jdbcDialect.parse(tableConfig.getTablePath());
            CatalogTable tableOfPath = null;
            try {
                tableOfPath = CatalogUtils.getCatalogTable(connection, tablePath, jdbcDialect.getJdbcDialectTypeMapper());
            }
            catch (Exception e) {
                log.debug("User-defined table path: {}", (Object)tablePath);
            }
            CatalogTable tableOfQuery = JdbcCatalogUtils.getCatalogTable(connection, tableConfig.getQuery(), jdbcDialect);
            if (tableOfPath == null) {
                String catalogName = tableOfQuery.getTableId() == null ? DEFAULT_CATALOG_NAME : tableOfQuery.getTableId().getCatalogName();
                TableIdentifier tableIdentifier = TableIdentifier.of((String)catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getSchemaName(), (String)tablePath.getTableName());
                return CatalogTable.of((TableIdentifier)tableIdentifier, (CatalogTable)tableOfQuery);
            }
            return JdbcCatalogUtils.mergeCatalogTable(tableOfPath, tableOfQuery);
        }
        if (StringUtils.isNotEmpty((CharSequence)tableConfig.getTablePath())) {
            TablePath tablePath = jdbcDialect.parse(tableConfig.getTablePath());
            return CatalogUtils.getCatalogTable(connection, tablePath, jdbcDialect.getJdbcDialectTypeMapper());
        }
        return JdbcCatalogUtils.getCatalogTable(connection, tableConfig.getQuery(), jdbcDialect);
    }

    private static CatalogTable getCatalogTable(Connection connection, String sqlQuery, JdbcDialect jdbcDialect) throws SQLException {
        ResultSetMetaData resultSetMetaData = jdbcDialect.getResultSetMetaData(connection, sqlQuery);
        return CatalogUtils.getCatalogTable(resultSetMetaData, jdbcDialect.getJdbcDialectTypeMapper(), sqlQuery);
    }

    private static Connection getConnection(JdbcConnectionConfig config, JdbcDialect jdbcDialect) throws SQLException, ClassNotFoundException {
        JdbcConnectionProvider connectionProvider = jdbcDialect.getJdbcConnectionProvider(config);
        return connectionProvider.getOrEstablishConnection();
    }

    public static Optional<Catalog> findCatalog(JdbcConnectionConfig config, JdbcDialect dialect) {
        ReadonlyConfig catalogConfig = JdbcCatalogUtils.extractCatalogConfig(config);
        return FactoryUtil.createOptionalCatalog((String)dialect.dialectName(), (ReadonlyConfig)catalogConfig, (ClassLoader)JdbcCatalogUtils.class.getClassLoader(), (String)dialect.dialectName());
    }

    private static ReadonlyConfig extractCatalogConfig(JdbcConnectionConfig config) {
        HashMap<String, Object> catalogConfig = new HashMap<String, Object>();
        catalogConfig.put(JdbcCatalogOptions.BASE_URL.key(), config.getUrl());
        config.getUsername().ifPresent(val -> catalogConfig.put(JdbcCatalogOptions.USERNAME.key(), val));
        config.getPassword().ifPresent(val -> catalogConfig.put(JdbcCatalogOptions.PASSWORD.key(), val));
        Optional.ofNullable(config.getCompatibleMode()).ifPresent(val -> catalogConfig.put(JdbcCatalogOptions.COMPATIBLE_MODE.key(), val));
        catalogConfig.put(JdbcOptions.DECIMAL_TYPE_NARROWING.key(), config.isDecimalTypeNarrowing());
        return ReadonlyConfig.fromMap(catalogConfig);
    }
}

