/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.format.protobuf.CompileDescriptor;

public class ProtobufToRowConverter
implements Serializable {
    private static final long serialVersionUID = 8177020083886379563L;
    private Descriptors.Descriptor descriptor = null;
    private String protoContent;
    private String messageName;

    public ProtobufToRowConverter(String protoContent, String messageName) {
        this.protoContent = protoContent;
        this.messageName = messageName;
    }

    public Descriptors.Descriptor getDescriptor() {
        if (this.descriptor == null) {
            try {
                this.descriptor = this.createDescriptor();
            }
            catch (Descriptors.DescriptorValidationException | IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.descriptor;
    }

    private Descriptors.Descriptor createDescriptor() throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        return CompileDescriptor.compileDescriptorTempFile(this.protoContent, this.messageName);
    }

    public SeaTunnelRow converter(Descriptors.Descriptor descriptor, DynamicMessage dynamicMessage, SeaTunnelRowType rowType) {
        String[] fieldNames = rowType.getFieldNames();
        Object[] values = new Object[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            Descriptors.FieldDescriptor fieldByName = descriptor.findFieldByName(fieldNames[i]);
            values[i] = fieldByName == null && descriptor.findNestedTypeByName(fieldNames[i]) == null ? null : this.convertField(descriptor, dynamicMessage, rowType.getFieldType(i), fieldByName == null ? null : dynamicMessage.getField(fieldByName), fieldNames[i]);
        }
        return new SeaTunnelRow(values);
    }

    private Object convertField(Descriptors.Descriptor descriptor, DynamicMessage dynamicMessage, SeaTunnelDataType<?> dataType, Object val, String fieldName) {
        switch (dataType.getSqlType()) {
            case STRING: {
                return val.toString();
            }
            case BOOLEAN: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case NULL: 
            case DATE: 
            case DECIMAL: 
            case TIMESTAMP: {
                return val;
            }
            case BYTES: {
                return ((ByteString)val).toByteArray();
            }
            case SMALLINT: {
                return ((Integer)val).shortValue();
            }
            case TINYINT: {
                Class typeClass = dataType.getTypeClass();
                if (typeClass == Byte.class) {
                    Integer integer = (Integer)val;
                    return integer.byteValue();
                }
                return val;
            }
            case MAP: {
                MapType mapType = (MapType)dataType;
                Map<Object, Object> res = ((List)val).stream().collect(Collectors.toMap(dm -> this.convertField(descriptor, (DynamicMessage)dm, (SeaTunnelDataType<?>)mapType.getKeyType(), this.getFieldValue((DynamicMessage)dm, "key"), null), dm -> this.convertField(descriptor, (DynamicMessage)dm, (SeaTunnelDataType<?>)mapType.getValueType(), this.getFieldValue((DynamicMessage)dm, "value"), null)));
                return res;
            }
            case ROW: {
                Descriptors.Descriptor nestedTypeByName = descriptor.findNestedTypeByName(fieldName);
                DynamicMessage s2 = (DynamicMessage)dynamicMessage.getField(descriptor.findFieldByName(fieldName.toLowerCase()));
                return this.converter(nestedTypeByName, s2, (SeaTunnelRowType)dataType);
            }
            case ARRAY: {
                SeaTunnelDataType basicType = ((ArrayType)dataType).getElementType();
                List list = (List)val;
                return this.convertArray(list, basicType);
            }
        }
        String errorMsg = String.format("SeaTunnel avro format is not supported for this data type [%s]", dataType.getSqlType());
        throw new RuntimeException(errorMsg);
    }

    private Object getFieldValue(DynamicMessage dm, String fieldName) {
        return dm.getAllFields().entrySet().stream().filter(entry -> ((Descriptors.FieldDescriptor)entry.getKey()).getName().equals(fieldName)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    protected Object convertArray(List<Object> val, SeaTunnelDataType<?> dataType) {
        if (val == null) {
            return null;
        }
        int length = val.size();
        Object instance = Array.newInstance(dataType.getTypeClass(), length);
        for (int i = 0; i < val.size(); ++i) {
            Array.set(instance, i, this.convertField(null, null, dataType, val.get(i), null));
        }
        return instance;
    }
}

