/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kafka.sink;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableFactoryContext;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.connectors.seatunnel.kafka.config.Config;
import org.apache.seatunnel.connectors.seatunnel.kafka.config.MessageFormat;
import org.apache.seatunnel.connectors.seatunnel.kafka.sink.KafkaSink;

@AutoService(value={Factory.class})
public class KafkaSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Kafka";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{Config.FORMAT, Config.BOOTSTRAP_SERVERS}).conditional(Config.FORMAT, Arrays.asList(MessageFormat.JSON, MessageFormat.CANAL_JSON, MessageFormat.TEXT), new Option[]{Config.TOPIC}).optional(new Option[]{Config.KAFKA_CONFIG, Config.ASSIGN_PARTITIONS, Config.TRANSACTION_PREFIX, Config.SEMANTICS, Config.PARTITION, Config.PARTITION_KEY_FIELDS}).build();
    }

    public TableSink createSink(TableFactoryContext context) {
        return () -> new KafkaSink(context.getOptions(), context.getCatalogTable().getTableSchema().toPhysicalRowDataType());
    }
}

