/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kafka.source;

import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.TablePath;

public class KafkaSourceSplit
implements SourceSplit {
    private TablePath tablePath;
    private TopicPartition topicPartition;
    private long startOffset = -1L;
    private long endOffset = -1L;

    public KafkaSourceSplit(TablePath tablePath, TopicPartition topicPartition) {
        this.tablePath = tablePath;
        this.topicPartition = topicPartition;
    }

    public KafkaSourceSplit(TablePath tablePath, TopicPartition topicPartition, long startOffset, long endOffset) {
        this.tablePath = tablePath;
        this.topicPartition = topicPartition;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(long endOffset) {
        this.endOffset = endOffset;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public void setTopicPartition(TopicPartition topicPartition) {
        this.topicPartition = topicPartition;
    }

    public TablePath getTablePath() {
        return this.tablePath;
    }

    public void setTablePath(TablePath tablePath) {
        this.tablePath = tablePath;
    }

    public String splitId() {
        return this.topicPartition.topic() + "-" + this.topicPartition.partition();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaSourceSplit that = (KafkaSourceSplit)o;
        return Objects.equals(this.topicPartition, that.topicPartition);
    }

    public int hashCode() {
        return Objects.hash(this.topicPartition);
    }

    public KafkaSourceSplit copy() {
        return new KafkaSourceSplit(this.tablePath, this.topicPartition, this.getStartOffset(), this.getEndOffset());
    }
}

