/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.avro;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumWriter;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.format.avro.SeaTunnelRowTypeToAvroSchemaConverter;
import org.apache.seatunnel.format.avro.exception.AvroFormatErrorCode;
import org.apache.seatunnel.format.avro.exception.SeaTunnelAvroFormatException;

public class RowToAvroConverter
implements Serializable {
    private static final long serialVersionUID = -576124379280229724L;
    private final Schema schema;
    private final SeaTunnelRowType rowType;
    private final DatumWriter<GenericRecord> writer;

    public RowToAvroConverter(SeaTunnelRowType rowType) {
        this.schema = SeaTunnelRowTypeToAvroSchemaConverter.buildAvroSchemaWithRowType(rowType);
        this.rowType = rowType;
        this.writer = this.createWriter();
    }

    private DatumWriter<GenericRecord> createWriter() {
        GenericDatumWriter<GenericRecord> datumWriter = new GenericDatumWriter<GenericRecord>(this.schema);
        datumWriter.getData().addLogicalTypeConversion(new Conversions.DecimalConversion());
        datumWriter.getData().addLogicalTypeConversion(new TimeConversions.DateConversion());
        datumWriter.getData().addLogicalTypeConversion(new TimeConversions.LocalTimestampMillisConversion());
        return datumWriter;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public DatumWriter<GenericRecord> getWriter() {
        return this.writer;
    }

    public GenericRecord convertRowToGenericRecord(SeaTunnelRow element) {
        GenericRecordBuilder builder = new GenericRecordBuilder(this.schema);
        String[] fieldNames = this.rowType.getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = this.rowType.getFieldName(i);
            Object value = element.getField(i);
            builder.set(fieldName.toLowerCase(), this.resolveObject(value, this.rowType.getFieldType(i)));
        }
        return builder.build();
    }

    private Object resolveObject(Object data, SeaTunnelDataType<?> seaTunnelDataType) {
        if (data == null) {
            return null;
        }
        switch (seaTunnelDataType.getSqlType()) {
            case STRING: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case MAP: 
            case DECIMAL: 
            case DATE: 
            case TIMESTAMP: {
                return data;
            }
            case TINYINT: {
                Class typeClass = seaTunnelDataType.getTypeClass();
                if (typeClass == Byte.class && data instanceof Byte) {
                    Byte aByte = (Byte)data;
                    return Byte.toUnsignedInt(aByte);
                }
                return data;
            }
            case BYTES: {
                return ByteBuffer.wrap((byte[])data);
            }
            case ARRAY: {
                SeaTunnelDataType basicType = ((ArrayType)seaTunnelDataType).getElementType();
                int length = Array.getLength(data);
                ArrayList<Object> records = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    records.add(this.resolveObject(Array.get(data, i), basicType));
                }
                return records;
            }
            case ROW: {
                SeaTunnelRow seaTunnelRow = (SeaTunnelRow)data;
                SeaTunnelDataType[] fieldTypes = ((SeaTunnelRowType)seaTunnelDataType).getFieldTypes();
                String[] fieldNames = ((SeaTunnelRowType)seaTunnelDataType).getFieldNames();
                Schema recordSchema = SeaTunnelRowTypeToAvroSchemaConverter.buildAvroSchemaWithRowType((SeaTunnelRowType)seaTunnelDataType);
                GenericRecordBuilder recordBuilder = new GenericRecordBuilder(recordSchema);
                for (int i = 0; i < fieldNames.length; ++i) {
                    recordBuilder.set(fieldNames[i].toLowerCase(), this.resolveObject(seaTunnelRow.getField(i), fieldTypes[i]));
                }
                return recordBuilder.build();
            }
        }
        String errorMsg = String.format("SeaTunnel avro format is not supported for this data type [%s]", seaTunnelDataType.getSqlType());
        throw new SeaTunnelAvroFormatException(AvroFormatErrorCode.UNSUPPORTED_DATA_TYPE, errorMsg);
    }
}

