/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.avro;

import java.util.ArrayList;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.format.avro.exception.AvroFormatErrorCode;
import org.apache.seatunnel.format.avro.exception.SeaTunnelAvroFormatException;

public class SeaTunnelRowTypeToAvroSchemaConverter {
    public static Schema buildAvroSchemaWithRowType(SeaTunnelRowType seaTunnelRowType) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        SeaTunnelDataType[] fieldTypes = seaTunnelRowType.getFieldTypes();
        String[] fieldNames = seaTunnelRowType.getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            fields.add(SeaTunnelRowTypeToAvroSchemaConverter.generateField(fieldNames[i], fieldTypes[i]));
        }
        return Schema.createRecord("SeaTunnelRecord", null, null, false, fields);
    }

    private static Schema.Field generateField(String fieldName, SeaTunnelDataType<?> seaTunnelDataType) {
        return new Schema.Field(fieldName, SeaTunnelRowTypeToAvroSchemaConverter.seaTunnelDataType2AvroDataType(fieldName, seaTunnelDataType), null, null);
    }

    private static Schema seaTunnelDataType2AvroDataType(String fieldName, SeaTunnelDataType<?> seaTunnelDataType) {
        switch (seaTunnelDataType.getSqlType()) {
            case STRING: {
                return Schema.create(Schema.Type.STRING);
            }
            case BYTES: {
                return Schema.create(Schema.Type.BYTES);
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                return Schema.create(Schema.Type.INT);
            }
            case BIGINT: {
                return Schema.create(Schema.Type.LONG);
            }
            case FLOAT: {
                return Schema.create(Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create(Schema.Type.DOUBLE);
            }
            case BOOLEAN: {
                return Schema.create(Schema.Type.BOOLEAN);
            }
            case MAP: {
                SeaTunnelDataType valueType = ((MapType)seaTunnelDataType).getValueType();
                return Schema.createMap(SeaTunnelRowTypeToAvroSchemaConverter.seaTunnelDataType2AvroDataType(fieldName, valueType));
            }
            case ARRAY: {
                SeaTunnelDataType elementType = ((ArrayType)seaTunnelDataType).getElementType();
                return Schema.createArray(SeaTunnelRowTypeToAvroSchemaConverter.seaTunnelDataType2AvroDataType(fieldName, elementType));
            }
            case ROW: {
                SeaTunnelDataType[] fieldTypes = ((SeaTunnelRowType)seaTunnelDataType).getFieldTypes();
                String[] fieldNames = ((SeaTunnelRowType)seaTunnelDataType).getFieldNames();
                ArrayList<Schema.Field> subField = new ArrayList<Schema.Field>();
                for (int i = 0; i < fieldNames.length; ++i) {
                    subField.add(SeaTunnelRowTypeToAvroSchemaConverter.generateField(fieldNames[i], fieldTypes[i]));
                }
                return Schema.createRecord(fieldName, null, null, false, subField);
            }
            case DECIMAL: {
                int precision = ((DecimalType)seaTunnelDataType).getPrecision();
                int scale = ((DecimalType)seaTunnelDataType).getScale();
                LogicalTypes.Decimal decimal = LogicalTypes.decimal(precision, scale);
                return decimal.addToSchema(Schema.create(Schema.Type.BYTES));
            }
            case TIMESTAMP: {
                return LogicalTypes.localTimestampMillis().addToSchema(Schema.create(Schema.Type.LONG));
            }
            case DATE: {
                return LogicalTypes.date().addToSchema(Schema.create(Schema.Type.INT));
            }
            case NULL: {
                return Schema.create(Schema.Type.NULL);
            }
        }
        String errorMsg = String.format("SeaTunnel avro format is not supported for this data type [%s]", seaTunnelDataType.getSqlType());
        throw new SeaTunnelAvroFormatException(AvroFormatErrorCode.UNSUPPORTED_DATA_TYPE, errorMsg);
    }
}

