/*
 * Decompiled with CFR 0.152.
 */
package com.stumbleupon.async;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.CallbackOverflowError;
import com.stumbleupon.async.DeferredGroup;
import com.stumbleupon.async.TimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Deferred<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Deferred.class);
    private static final short MAX_CALLBACK_CHAIN_LENGTH = 16383;
    private static final byte INIT_CALLBACK_CHAIN_SIZE = 4;
    private static final byte PENDING = 0;
    private static final byte RUNNING = 1;
    private static final byte PAUSED = 2;
    private static final byte DONE = 3;
    private volatile int state;
    private Object result;
    private Callback[] callbacks;
    private short next_callback;
    private short last_callback;
    private static final AtomicIntegerFieldUpdater<Deferred> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(Deferred.class, "state");

    private boolean casState(int cmp, int val) {
        return stateUpdater.compareAndSet(this, cmp, val);
    }

    public Deferred() {
        this.state = 0;
    }

    private Deferred(Object result2) {
        this.result = result2;
        this.state = 3;
    }

    public static <T> Deferred<T> fromResult(T result2) {
        return new Deferred<T>(result2);
    }

    public static <T> Deferred<T> fromError(Exception error) {
        return new Deferred<T>(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, R2, E> Deferred<R> addCallbacks(Callback<R, T> cb, Callback<R2, E> eb) {
        if (cb == null) {
            throw new NullPointerException("null callback");
        }
        if (eb == null) {
            throw new NullPointerException("null errback");
        }
        Deferred deferred = this;
        synchronized (deferred) {
            if (this.state != 3) {
                if (this.callbacks == null) {
                    this.callbacks = new Callback[4];
                } else if (this.last_callback == this.callbacks.length) {
                    int oldlen = this.callbacks.length;
                    if (oldlen == 32766) {
                        throw new CallbackOverflowError("Too many callbacks in " + this + " (size=" + oldlen / 2 + ") when attempting to add cb=" + cb + '@' + cb.hashCode() + ", eb=" + eb + '@' + eb.hashCode());
                    }
                    int len = Math.min(oldlen * 2, 32766);
                    Callback[] newcbs = new Callback[len];
                    System.arraycopy(this.callbacks, this.next_callback, newcbs, 0, this.last_callback - this.next_callback);
                    this.last_callback = (short)(this.last_callback - this.next_callback);
                    this.next_callback = 0;
                    this.callbacks = newcbs;
                }
                short s2 = this.last_callback;
                this.last_callback = (short)(s2 + 1);
                this.callbacks[s2] = cb;
                short s3 = this.last_callback;
                this.last_callback = (short)(s3 + 1);
                this.callbacks[s3] = eb;
                return this;
            }
            this.state = 1;
        }
        if (!this.doCall(this.result instanceof Exception ? eb : cb)) {
            boolean more;
            Deferred deferred2 = this;
            synchronized (deferred2) {
                more = this.callbacks != null && this.next_callback != this.last_callback;
            }
            if (more) {
                this.runCallbacks();
            } else {
                this.state = 3;
            }
        }
        return this;
    }

    public <R> Deferred<R> addCallback(Callback<R, T> cb) {
        return this.addCallbacks(cb, Callback.PASSTHROUGH);
    }

    public <R, D extends Deferred<R>> Deferred<R> addCallbackDeferring(Callback<D, T> cb) {
        return this.addCallbacks(cb, Callback.PASSTHROUGH);
    }

    public <R, E> Deferred<T> addErrback(Callback<R, E> eb) {
        return this.addCallbacks(Callback.PASSTHROUGH, eb);
    }

    public <R> Deferred<R> addBoth(Callback<R, T> cb) {
        return this.addCallbacks(cb, cb);
    }

    public <R, D extends Deferred<R>> Deferred<R> addBothDeferring(Callback<D, T> cb) {
        return this.addCallbacks(cb, cb);
    }

    public Deferred<T> chain(Deferred<T> other) {
        if (this == other) {
            throw new AssertionError((Object)("A Deferred cannot be chained to itself.  this=" + this));
        }
        Chain<T> cb = new Chain<T>(other);
        return this.addCallbacks(cb, cb);
    }

    public static <T> Deferred<ArrayList<T>> group(Collection<Deferred<T>> deferreds) {
        return new DeferredGroup<T>(deferreds, false).getDeferred();
    }

    public static <T> Deferred<ArrayList<T>> groupInOrder(Collection<Deferred<T>> deferreds) {
        return new DeferredGroup<T>(deferreds, true).getDeferred();
    }

    public static <T> Deferred<ArrayList<T>> group(Deferred<T> d1, Deferred<T> d2) {
        ArrayList tmp = new ArrayList(2);
        tmp.add(d1);
        tmp.add(d2);
        return new DeferredGroup(tmp, false).getDeferred();
    }

    public static <T> Deferred<ArrayList<T>> group(Deferred<T> d1, Deferred<T> d2, Deferred<T> d3) {
        ArrayList tmp = new ArrayList(3);
        tmp.add(d1);
        tmp.add(d2);
        tmp.add(d3);
        return new DeferredGroup(tmp, false).getDeferred();
    }

    public void callback(Object initresult) {
        if (!this.casState(0, 1)) {
            throw new AssertionError((Object)("This Deferred was already called!  New result=" + initresult + ", this=" + this));
        }
        this.result = initresult;
        if (initresult instanceof Deferred) {
            Deferred d = (Deferred)initresult;
            if (this == d) {
                throw new AssertionError((Object)("A Deferred cannot be given to itself as a result.  this=" + this));
            }
            this.handleContinuation(d, null);
        }
        this.runCallbacks();
    }

    public T join() throws InterruptedException, Exception {
        return this.doJoin(true, 0L);
    }

    public T join(long timeout) throws InterruptedException, Exception {
        return this.doJoin(true, timeout);
    }

    public T joinUninterruptibly() throws Exception {
        try {
            return this.doJoin(false, 0L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"Impossible");
        }
    }

    public T joinUninterruptibly(long timeout) throws Exception {
        try {
            return this.doJoin(false, timeout);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"Impossible");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T doJoin(boolean interruptible, long timeout) throws InterruptedException, Exception {
        if (this.state == 3) {
            if (this.result instanceof Exception) {
                throw (Exception)this.result;
            }
            return (T)this.result;
        }
        Signal signal_cb = new Signal();
        boolean interrupted = false;
        while (true) {
            try {
                boolean timedout = false;
                Object object = signal_cb;
                synchronized (object) {
                    this.addBoth(signal_cb);
                    if (timeout == 0L) {
                        while (signal_cb.result == signal_cb) {
                            signal_cb.wait();
                        }
                    } else {
                        if (timeout < 0L) {
                            throw new IllegalArgumentException("negative timeout: " + timeout);
                        }
                        long timeleft = timeout * 1000000L;
                        if (timeout > 31556926000L) {
                            LOG.warn("Timeout (" + timeout + ") is long than 1 year." + "  this=" + this);
                            if (timeleft <= 0L) {
                                throw new IllegalArgumentException("timeout overflow after conversion to nanoseconds: " + timeout);
                            }
                        }
                        while (signal_cb.result == signal_cb) {
                            long duration = System.nanoTime();
                            long millis = timeleft / 1000000L;
                            int nanos = (int)(timeleft % 1000000L);
                            signal_cb.wait(millis, nanos);
                            duration = System.nanoTime() - duration;
                            if ((timeleft -= duration) >= 100L) continue;
                            timedout = true;
                            break;
                        }
                    }
                }
                if (timedout && signal_cb.result == signal_cb) {
                    throw new TimeoutException(this, timeout);
                }
                if (signal_cb.result instanceof Exception) {
                    throw (Exception)signal_cb.result;
                }
                object = signal_cb.result;
                return (T)object;
            }
            catch (InterruptedException e) {
                LOG.debug("While joining {}: interrupted", (Object)this);
                interrupted = true;
                if (!interruptible) continue;
                throw e;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCallbacks() {
        Callback cb;
        Callback eb;
        do {
            cb = null;
            eb = null;
            Deferred deferred = this;
            synchronized (deferred) {
                if (this.callbacks == null || this.next_callback == this.last_callback) {
                    this.state = 3;
                    this.callbacks = null;
                    this.last_callback = 0;
                    this.next_callback = 0;
                    break;
                }
                short s2 = this.next_callback;
                this.next_callback = (short)(s2 + 1);
                cb = this.callbacks[s2];
                short s3 = this.next_callback;
                this.next_callback = (short)(s3 + 1);
                eb = this.callbacks[s3];
            }
        } while (!this.doCall(this.result instanceof Exception ? eb : cb));
    }

    private boolean doCall(Callback cb) {
        try {
            this.result = cb.call(this.result);
        }
        catch (Exception e) {
            this.result = e;
        }
        if (this.result instanceof Deferred) {
            this.handleContinuation((Deferred)this.result, cb);
            return true;
        }
        return false;
    }

    private void handleContinuation(Deferred d, Callback cb) {
        if (this == d) {
            String cb2s = cb == null ? "null" : cb + "@" + cb.hashCode();
            throw new AssertionError((Object)("After " + this + " executed callback=" + cb2s + ", the result returned was the same Deferred object.  This is illegal" + ", a Deferred can't run itself recursively.  Something is wrong."));
        }
        if (d.casState(3, 1)) {
            this.result = d.result;
            d.state = 3;
            this.runCallbacks();
            return;
        }
        this.state = 2;
        d.addBoth(new Continue(d, cb));
        if (LOG.isDebugEnabled() && this.state == 2) {
            if (cb != null) {
                LOG.debug("callback=" + cb + '@' + cb.hashCode() + " returned " + d + ", so the following Deferred is getting paused: " + this);
            } else {
                LOG.debug("The following Deferred is getting paused: " + this + " as it received another Deferred as a result: " + d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int state = this.state;
        Object result2 = this.result;
        String str = result2 == null ? "null" : (result2 instanceof Deferred ? "Deferred@" + result2.hashCode() : result2.toString());
        StringBuilder buf = new StringBuilder((33 + str.length()) * 2);
        buf.append("Deferred@").append(super.hashCode()).append("(state=").append(Deferred.stateString(state)).append(", result=").append(str).append(", callback=");
        Deferred deferred = this;
        synchronized (deferred) {
            if (this.callbacks == null || this.next_callback == this.last_callback) {
                buf.append("<none>, errback=<none>");
            } else {
                int i;
                for (i = this.next_callback; i < this.last_callback; i += 2) {
                    buf.append(this.callbacks[i]).append(" -> ");
                }
                buf.setLength(buf.length() - 4);
                buf.append(", errback=");
                for (i = this.next_callback + 1; i < this.last_callback; i += 2) {
                    buf.append(this.callbacks[i]).append(" -> ");
                }
                buf.setLength(buf.length() - 4);
            }
        }
        buf.append(')');
        return buf.toString();
    }

    private static String stateString(int state) {
        switch (state) {
            case 0: {
                return "PENDING";
            }
            case 1: {
                return "RUNNING";
            }
            case 2: {
                return "PAUSED";
            }
            case 3: {
                return "DONE";
            }
        }
        throw new AssertionError((Object)("Should never be here.  WTF: state=" + state));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Continue
    implements Callback<Object, Object> {
        private final Deferred d;
        private final Callback cb;

        public Continue(Deferred d, Callback cb) {
            this.d = d;
            this.cb = cb;
        }

        @Override
        public Object call(Object arg) {
            if (arg instanceof Deferred) {
                Deferred.this.handleContinuation((Deferred)arg, this.cb);
            } else if (!Deferred.this.casState(2, 1)) {
                String cb2s = this.cb == null ? "null" : this.cb + "@" + this.cb.hashCode();
                throw new AssertionError((Object)("Tried to resume the execution of " + Deferred.this + ") although it's not in state=PAUSED." + "  This occurred after the completion of " + this.d + " which was originally returned by callback=" + cb2s));
            }
            Deferred.this.result = arg;
            Deferred.this.runCallbacks();
            return arg;
        }

        public String toString() {
            return "(continuation of Deferred@" + Deferred.super.hashCode() + " after " + (this.cb != null ? this.cb + "@" + this.cb.hashCode() : this.d) + ')';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Signal
    implements Callback<Object, Object> {
        Object result = this;
        private final String thread = Thread.currentThread().getName();

        Signal() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call(Object arg) {
            Signal signal = this;
            synchronized (signal) {
                this.result = arg;
                super.notify();
            }
            return arg;
        }

        public String toString() {
            return "wakeup thread " + this.thread;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Chain<T>
    implements Callback<T, T> {
        private final Deferred<T> other;

        public Chain(Deferred<T> other) {
            this.other = other;
        }

        @Override
        public T call(T arg) {
            this.other.callback(arg);
            return arg;
        }

        public String toString() {
            return "chain with Deferred@" + this.other.hashCode();
        }
    }
}

