/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.kudu.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class IPCUtil {
    public static int write(OutputStream dos, Message header, Message param2) throws IOException {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, param2);
        return IPCUtil.write(dos, header, param2, totalSize);
    }

    private static int write(OutputStream dos, Message header, Message param2, int totalSize) throws IOException {
        dos.write(IPCUtil.toBytes(totalSize));
        header.writeDelimitedTo(dos);
        if (param2 != null) {
            param2.writeDelimitedTo(dos);
        }
        dos.flush();
        return totalSize;
    }

    public static int getTotalSizeWhenWrittenDelimited(Message ... messages) {
        int totalSize = 0;
        for (Message m3 : messages) {
            if (m3 == null) continue;
            totalSize += m3.getSerializedSize();
            totalSize += CodedOutputStream.computeUInt32SizeNoTag(m3.getSerializedSize());
        }
        return totalSize;
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }
}

