/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.DeferredGroupException;
import com.stumbleupon.async.TimeoutException;
import java.io.IOException;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.Status;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class KuduException
extends IOException {
    private final Status status;

    KuduException(Status status) {
        super(status.getMessage());
        this.status = status;
    }

    KuduException(Status status, Throwable cause) {
        super(status.getMessage(), cause);
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    static KuduException transformException(Exception e) {
        String message;
        String string2 = message = e.getMessage() == null ? "" : e.getMessage();
        if (e instanceof KuduException) {
            e.addSuppressed(new OriginalException(e));
            StackTraceElement[] stack = new Exception().getStackTrace();
            e.setStackTrace(stack);
            return (KuduException)e;
        }
        if (e instanceof DeferredGroupException) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                return KuduException.transformException((Exception)cause);
            }
        } else {
            if (e instanceof TimeoutException) {
                Status statusTimeout = Status.TimedOut(message);
                return new NonRecoverableException(statusTimeout, (Throwable)e);
            }
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                Status statusAborted = Status.Aborted(message);
                return new NonRecoverableException(statusAborted, (Throwable)e);
            }
        }
        Status status = Status.IOError(message);
        return new NonRecoverableException(status, (Throwable)e);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class OriginalException
    extends Throwable {
        private OriginalException(Throwable e) {
            super("Original asynchronous stack trace");
            this.setStackTrace(e.getStackTrace());
        }
    }
}

