/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Common;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AbstractKuduScannerBuilder;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.Client;
import org.apache.kudu.client.KeyEncoder;
import org.apache.kudu.client.KeyRange;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.PartitionPruner;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.shaded.com.google.common.base.MoreObjects;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.protobuf.CodedInputStream;
import org.apache.kudu.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class KuduScanToken
implements Comparable<KuduScanToken> {
    private final LocatedTablet tablet;
    private final Client.ScanTokenPB message;

    private KuduScanToken(LocatedTablet tablet, Client.ScanTokenPB message) {
        this.tablet = tablet;
        this.message = message;
    }

    public LocatedTablet getTablet() {
        return this.tablet;
    }

    public KuduScanner intoScanner(KuduClient client) throws Exception {
        return KuduScanToken.pbIntoScanner(this.message, client);
    }

    public byte[] serialize() throws IOException {
        return KuduScanToken.serialize(this.message);
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    static byte[] serialize(Client.ScanTokenPB message) throws IOException {
        byte[] buf = new byte[message.getSerializedSize()];
        CodedOutputStream cos = CodedOutputStream.newInstance(buf);
        message.writeTo(cos);
        cos.flush();
        return buf;
    }

    public static KuduScanner deserializeIntoScanner(byte[] buf, KuduClient client) throws IOException {
        return KuduScanToken.pbIntoScanner(Client.ScanTokenPB.parseFrom(CodedInputStream.newInstance(buf)), client);
    }

    public static String stringifySerializedToken(byte[] buf, KuduClient client) throws IOException {
        Client.ScanTokenPB token = Client.ScanTokenPB.parseFrom(CodedInputStream.newInstance(buf));
        KuduTable table = token.hasTableId() ? client.openTableById(token.getTableId()) : client.openTable(token.getTableName());
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ScanToken").add("table-name", token.getTableName());
        if (token.hasTableId()) {
            helper.add("table-id", token.getTableId());
        }
        if (token.hasLowerBoundPrimaryKey() && !token.getLowerBoundPrimaryKey().isEmpty()) {
            helper.add("lower-bound-primary-key", KeyEncoder.decodePrimaryKey(table.getSchema(), token.getLowerBoundPrimaryKey().toByteArray()).stringifyRowKey());
        }
        if (token.hasUpperBoundPrimaryKey() && !token.getUpperBoundPrimaryKey().isEmpty()) {
            helper.add("upper-bound-primary-key", KeyEncoder.decodePrimaryKey(table.getSchema(), token.getUpperBoundPrimaryKey().toByteArray()).stringifyRowKey());
        }
        helper.addValue(KeyEncoder.formatPartitionKeyRange(table.getSchema(), table.getPartitionSchema(), token.getLowerBoundPartitionKey().toByteArray(), token.getUpperBoundPartitionKey().toByteArray()));
        return helper.toString();
    }

    private static List<Integer> computeProjectedColumnIndexesForScanner(Client.ScanTokenPB message, Schema schema) {
        ArrayList<Integer> columns = new ArrayList<Integer>(message.getProjectedColumnsCount());
        for (Common.ColumnSchemaPB colSchemaFromPb : message.getProjectedColumnsList()) {
            int colIdx = colSchemaFromPb.hasId() && schema.hasColumnIds() ? schema.getColumnIndex(colSchemaFromPb.getId()) : schema.getColumnIndex(colSchemaFromPb.getName());
            ColumnSchema colSchema = schema.getColumnByIndex(colIdx);
            if (colSchemaFromPb.getType() != colSchema.getType().getDataType(colSchema.getTypeAttributes())) {
                throw new IllegalStateException(String.format("invalid type %s for column '%s' in scan token, expected: %s", colSchemaFromPb.getType().name(), colSchemaFromPb.getName(), colSchema.getType().name()));
            }
            if (colSchemaFromPb.getIsNullable() != colSchema.isNullable()) {
                throw new IllegalStateException(String.format("invalid nullability for column '%s' in scan token, expected: %s", colSchemaFromPb.getName(), colSchema.isNullable() ? "NULLABLE" : "NOT NULL"));
            }
            columns.add(colIdx);
        }
        return columns;
    }

    private static KuduScanner pbIntoScanner(Client.ScanTokenPB message, KuduClient client) throws KuduException {
        Preconditions.checkArgument(!message.getFeatureFlagsList().contains(Client.ScanTokenPB.Feature.Unknown), "Scan token requires an unsupported feature. This Kudu client must be updated.");
        KuduTable table = message.hasTableId() ? client.openTableById(message.getTableId()) : client.openTable(message.getTableName());
        KuduScanner.KuduScannerBuilder builder = client.newScannerBuilder(table);
        builder.setProjectedColumnIndexes(KuduScanToken.computeProjectedColumnIndexesForScanner(message, table.getSchema()));
        for (Common.ColumnPredicatePB pred : message.getColumnPredicatesList()) {
            builder.addPredicate(KuduPredicate.fromPB(table.getSchema(), pred));
        }
        if (message.hasLowerBoundPrimaryKey()) {
            builder.lowerBoundRaw(message.getLowerBoundPrimaryKey().toByteArray());
        }
        if (message.hasUpperBoundPrimaryKey()) {
            builder.exclusiveUpperBoundRaw(message.getUpperBoundPrimaryKey().toByteArray());
        }
        if (message.hasLowerBoundPartitionKey()) {
            builder.lowerBoundPartitionKeyRaw(message.getLowerBoundPartitionKey().toByteArray());
        }
        if (message.hasUpperBoundPartitionKey()) {
            builder.exclusiveUpperBoundPartitionKeyRaw(message.getUpperBoundPartitionKey().toByteArray());
        }
        if (message.hasLimit()) {
            builder.limit(message.getLimit());
        }
        if (message.hasReadMode()) {
            switch (message.getReadMode()) {
                case READ_AT_SNAPSHOT: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT);
                    if (message.hasSnapTimestamp()) {
                        builder.snapshotTimestampRaw(message.getSnapTimestamp());
                    }
                    if (!message.hasSnapStartTimestamp()) break;
                    builder.diffScan(message.getSnapStartTimestamp(), message.getSnapTimestamp());
                    break;
                }
                case READ_LATEST: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_LATEST);
                    break;
                }
                case READ_YOUR_WRITES: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_YOUR_WRITES);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown read mode");
                }
            }
        }
        if (message.hasReplicaSelection()) {
            switch (message.getReplicaSelection()) {
                case LEADER_ONLY: {
                    builder.replicaSelection(ReplicaSelection.LEADER_ONLY);
                    break;
                }
                case CLOSEST_REPLICA: {
                    builder.replicaSelection(ReplicaSelection.CLOSEST_REPLICA);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown replica selection policy");
                }
            }
        }
        if (message.hasPropagatedTimestamp() && message.getPropagatedTimestamp() != -1L) {
            client.updateLastPropagatedTimestamp(message.getPropagatedTimestamp());
        }
        if (message.hasCacheBlocks()) {
            builder.cacheBlocks(message.getCacheBlocks());
        }
        if (message.hasFaultTolerant()) {
            builder.setFaultTolerant(message.getFaultTolerant());
        }
        if (message.hasBatchSizeBytes()) {
            builder.batchSizeBytes(message.getBatchSizeBytes());
        }
        if (message.hasScanRequestTimeoutMs()) {
            builder.scanRequestTimeout(message.getScanRequestTimeoutMs());
        }
        if (message.hasKeepAlivePeriodMs()) {
            builder.keepAlivePeriodMs(message.getKeepAlivePeriodMs());
        }
        return builder.build();
    }

    @Override
    public int compareTo(KuduScanToken other) {
        if (this.message.hasTableId() && other.message.hasTableId() ? !this.message.getTableId().equals(other.message.getTableId()) : !this.message.getTableName().equals(other.message.getTableName())) {
            throw new IllegalArgumentException("Scan tokens from different tables may not be compared");
        }
        return this.tablet.getPartition().compareTo(other.getTablet().getPartition());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class KuduScanTokenBuilder
    extends AbstractKuduScannerBuilder<KuduScanTokenBuilder, List<KuduScanToken>> {
        private static final int DEFAULT_SPLIT_SIZE_BYTES = -1;
        private long timeout;
        private long splitSizeBytes = -1L;

        KuduScanTokenBuilder(AsyncKuduClient client, KuduTable table) {
            super(client, table);
            this.timeout = client.getDefaultOperationTimeoutMs();
        }

        public KuduScanTokenBuilder setTimeout(long timeoutMs) {
            this.timeout = timeoutMs;
            return this;
        }

        public KuduScanTokenBuilder setSplitSizeBytes(long splitSizeBytes) {
            this.splitSizeBytes = splitSizeBytes;
            return this;
        }

        @Override
        public List<KuduScanToken> build() {
            ColumnSchema columnSchema;
            if (this.lowerBoundPartitionKey.length != 0 || this.upperBoundPartitionKey.length != 0) {
                throw new IllegalArgumentException("Partition key bounds may not be set on KuduScanTokenBuilder");
            }
            for (KuduPredicate predicate : this.predicates.values()) {
                if (predicate.getType() != KuduPredicate.PredicateType.NONE) continue;
                return new ArrayList<KuduScanToken>();
            }
            Client.ScanTokenPB.Builder proto = Client.ScanTokenPB.newBuilder();
            proto.setTableId(this.table.getTableId());
            proto.setTableName(this.table.getName());
            Schema schema = this.table.getSchema();
            if (this.projectedColumnNames != null) {
                for (String columnName : this.projectedColumnNames) {
                    columnSchema = schema.getColumn(columnName);
                    Preconditions.checkArgument(columnSchema != null, "unknown column i%s", (Object)columnName);
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), schema.hasColumnIds() ? schema.getColumnId(columnName) : -1, columnSchema);
                }
            } else if (this.projectedColumnIndexes != null) {
                Iterator<Object> iterator2 = this.projectedColumnIndexes.iterator();
                while (iterator2.hasNext()) {
                    int columnIdx = (Integer)iterator2.next();
                    columnSchema = schema.getColumnByIndex(columnIdx);
                    Preconditions.checkArgument(columnSchema != null, "unknown column index %s", columnIdx);
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), schema.hasColumnIds() ? schema.getColumnId(columnSchema.getName()) : -1, columnSchema);
                }
            } else {
                for (ColumnSchema column : schema.getColumns()) {
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), schema.hasColumnIds() ? schema.getColumnId(column.getName()) : -1, column);
                }
            }
            for (KuduPredicate predicate : this.predicates.values()) {
                proto.addColumnPredicates(predicate.toPB());
            }
            if (this.lowerBoundPrimaryKey.length > 0) {
                proto.setLowerBoundPrimaryKey(UnsafeByteOperations.unsafeWrap(this.lowerBoundPrimaryKey));
            }
            if (this.upperBoundPrimaryKey.length > 0) {
                proto.setUpperBoundPrimaryKey(UnsafeByteOperations.unsafeWrap(this.upperBoundPrimaryKey));
            }
            proto.setLimit(this.limit);
            proto.setReadMode(this.readMode.pbVersion());
            if (this.replicaSelection == ReplicaSelection.LEADER_ONLY) {
                proto.setReplicaSelection(Common.ReplicaSelection.LEADER_ONLY);
            } else if (this.replicaSelection == ReplicaSelection.CLOSEST_REPLICA) {
                proto.setReplicaSelection(Common.ReplicaSelection.CLOSEST_REPLICA);
            }
            if (this.table.getAsyncClient().getLastPropagatedTimestamp() != -1L) {
                proto.setPropagatedTimestamp(this.client.getLastPropagatedTimestamp());
            }
            if (this.readMode == AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT) {
                if (this.htTimestamp != -1L) {
                    proto.setSnapTimestamp(this.htTimestamp);
                }
                if (this.startTimestamp != -1L) {
                    proto.setSnapStartTimestamp(this.startTimestamp);
                }
            }
            proto.setCacheBlocks(this.cacheBlocks);
            proto.setFaultTolerant(this.isFaultTolerant);
            proto.setBatchSizeBytes(this.batchSizeBytes);
            proto.setScanRequestTimeoutMs(this.scanRequestTimeout);
            proto.setKeepAlivePeriodMs(this.keepAlivePeriodMs);
            try {
                PartitionPruner pruner = PartitionPruner.create(this);
                ArrayList<KeyRange> keyRanges = new ArrayList<KeyRange>();
                while (pruner.hasMorePartitionKeyRanges()) {
                    Pair<byte[], byte[]> partitionRange = pruner.nextPartitionKeyRange();
                    List<KeyRange> newKeyRanges = this.client.getTableKeyRanges(this.table, proto.getLowerBoundPrimaryKey().toByteArray(), proto.getUpperBoundPrimaryKey().toByteArray(), partitionRange.getFirst().length == 0 ? null : partitionRange.getFirst(), partitionRange.getSecond().length == 0 ? null : partitionRange.getSecond(), AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, this.splitSizeBytes, this.timeout).join();
                    if (newKeyRanges.isEmpty()) {
                        pruner.removePartitionKeyRange(partitionRange.getSecond());
                    } else {
                        pruner.removePartitionKeyRange(newKeyRanges.get(newKeyRanges.size() - 1).getPartitionKeyEnd());
                    }
                    keyRanges.addAll(newKeyRanges);
                }
                ArrayList<KuduScanToken> tokens = new ArrayList<KuduScanToken>(keyRanges.size());
                for (KeyRange keyRange : keyRanges) {
                    byte[] primaryKeyEnd;
                    Client.ScanTokenPB.Builder builder = proto.clone();
                    builder.setLowerBoundPartitionKey(UnsafeByteOperations.unsafeWrap(keyRange.getPartitionKeyStart()));
                    builder.setUpperBoundPartitionKey(UnsafeByteOperations.unsafeWrap(keyRange.getPartitionKeyEnd()));
                    byte[] primaryKeyStart = keyRange.getPrimaryKeyStart();
                    if (primaryKeyStart != null && primaryKeyStart.length > 0) {
                        builder.setLowerBoundPrimaryKey(UnsafeByteOperations.unsafeWrap(primaryKeyStart));
                    }
                    if ((primaryKeyEnd = keyRange.getPrimaryKeyEnd()) != null && primaryKeyEnd.length > 0) {
                        builder.setUpperBoundPrimaryKey(UnsafeByteOperations.unsafeWrap(primaryKeyEnd));
                    }
                    tokens.add(new KuduScanToken(keyRange.getTablet(), builder.build()));
                }
                return tokens;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

