/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.org.jboss.netty.handler.execution;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.kudu.shaded.org.jboss.netty.handler.execution.ChannelEventRunnable;
import org.apache.kudu.shaded.org.jboss.netty.handler.execution.ChannelEventRunnableFilter;
import org.apache.kudu.shaded.org.jboss.netty.util.ExternalResourceReleasable;

public class ChainedExecutor
implements Executor,
ExternalResourceReleasable {
    private final Executor cur;
    private final Executor next;
    private final ChannelEventRunnableFilter filter;

    public ChainedExecutor(ChannelEventRunnableFilter filter2, Executor cur, Executor next2) {
        if (filter2 == null) {
            throw new NullPointerException("filter");
        }
        if (cur == null) {
            throw new NullPointerException("cur");
        }
        if (next2 == null) {
            throw new NullPointerException("next");
        }
        this.filter = filter2;
        this.cur = cur;
        this.next = next2;
    }

    public void execute(Runnable command) {
        assert (command instanceof ChannelEventRunnable);
        if (this.filter.filter((ChannelEventRunnable)command)) {
            this.cur.execute(command);
        } else {
            this.next.execute(command);
        }
    }

    public void releaseExternalResources() {
        if (this.cur instanceof ExecutorService) {
            ((ExecutorService)this.cur).shutdown();
        }
        if (this.next instanceof ExecutorService) {
            ((ExecutorService)this.next).shutdown();
        }
        ChainedExecutor.releaseExternal(this.cur);
        ChainedExecutor.releaseExternal(this.next);
    }

    private static void releaseExternal(Executor executor) {
        if (executor instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)executor)).releaseExternalResources();
        }
    }
}

