/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kudu.config;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.kudu.exception.KuduConnectorException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class KuduSinkConfig {
    public static final Option<String> KUDU_MASTER = Options.key((String)"kudu_master").stringType().noDefaultValue().withDescription("kudu master address");
    public static final Option<SaveMode> KUDU_SAVE_MODE = Options.key((String)"save_mode").enumType(SaveMode.class).noDefaultValue().withDescription("Storage mode,append is now supported");
    public static final Option<String> KUDU_TABLE_NAME = Options.key((String)"kudu_table").stringType().noDefaultValue().withDescription("kudu table name");
    private SaveMode saveMode;
    private String kuduMaster;
    private String kuduTableName;

    public KuduSinkConfig(@NonNull Config pluginConfig) {
        if (pluginConfig == null) {
            throw new NullPointerException("pluginConfig is marked non-null but is null");
        }
        if (!(pluginConfig.hasPath(KUDU_SAVE_MODE.key()) && pluginConfig.hasPath(KUDU_MASTER.key()) && pluginConfig.hasPath(KUDU_TABLE_NAME.key()))) {
            throw new KuduConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", new Object[]{"Kudu", PluginType.SINK, "Missing Sink configuration parameters"}));
        }
        this.saveMode = StringUtils.isBlank(pluginConfig.getString(KUDU_SAVE_MODE.key())) ? SaveMode.APPEND : SaveMode.fromStr(pluginConfig.getString(KUDU_SAVE_MODE.key()));
        this.kuduMaster = pluginConfig.getString(KUDU_MASTER.key());
        this.kuduTableName = pluginConfig.getString(KUDU_TABLE_NAME.key());
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public String getKuduMaster() {
        return this.kuduMaster;
    }

    public String getKuduTableName() {
        return this.kuduTableName;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
    }

    public void setKuduMaster(String kuduMaster) {
        this.kuduMaster = kuduMaster;
    }

    public void setKuduTableName(String kuduTableName) {
        this.kuduTableName = kuduTableName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KuduSinkConfig)) {
            return false;
        }
        KuduSinkConfig other = (KuduSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SaveMode this$saveMode = this.getSaveMode();
        SaveMode other$saveMode = other.getSaveMode();
        if (this$saveMode == null ? other$saveMode != null : !((Object)((Object)this$saveMode)).equals((Object)other$saveMode)) {
            return false;
        }
        String this$kuduMaster = this.getKuduMaster();
        String other$kuduMaster = other.getKuduMaster();
        if (this$kuduMaster == null ? other$kuduMaster != null : !this$kuduMaster.equals(other$kuduMaster)) {
            return false;
        }
        String this$kuduTableName = this.getKuduTableName();
        String other$kuduTableName = other.getKuduTableName();
        return !(this$kuduTableName == null ? other$kuduTableName != null : !this$kuduTableName.equals(other$kuduTableName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KuduSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        SaveMode $saveMode = this.getSaveMode();
        result2 = result2 * 59 + ($saveMode == null ? 43 : ((Object)((Object)$saveMode)).hashCode());
        String $kuduMaster = this.getKuduMaster();
        result2 = result2 * 59 + ($kuduMaster == null ? 43 : $kuduMaster.hashCode());
        String $kuduTableName = this.getKuduTableName();
        result2 = result2 * 59 + ($kuduTableName == null ? 43 : $kuduTableName.hashCode());
        return result2;
    }

    public String toString() {
        return "KuduSinkConfig(saveMode=" + (Object)((Object)this.getSaveMode()) + ", kuduMaster=" + this.getKuduMaster() + ", kuduTableName=" + this.getKuduTableName() + ")";
    }

    public static enum SaveMode {
        APPEND,
        OVERWRITE;


        public static SaveMode fromStr(String str) {
            if ("overwrite".equals(str)) {
                return OVERWRITE;
            }
            return APPEND;
        }
    }
}

