/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kudu.kuduclient;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.RowResult;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.connectors.seatunnel.kudu.exception.KuduConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.kudu.exception.KuduConnectorException;
import org.apache.seatunnel.connectors.seatunnel.kudu.kuduclient.KuduTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduInputFormat
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(KuduInputFormat.class);
    public KuduClient kuduClient;
    public String kuduMaster;
    public List<String> columnsList;
    public Schema schema;
    public String keyColumn;
    public static final int TIMEOUTMS = 18000;
    public String tableName;

    public KuduInputFormat(String kuduMaster, String tableName, String columnsList) {
        this.kuduMaster = kuduMaster;
        this.columnsList = Arrays.asList(columnsList.split(","));
        this.tableName = tableName;
    }

    public List<ColumnSchema> getColumnsSchemas() {
        List<ColumnSchema> columns = null;
        try {
            this.schema = this.kuduClient.openTable(this.tableName).getSchema();
            this.keyColumn = this.schema.getPrimaryKeyColumns().get(0).getName();
            columns = this.schema.getColumns();
        }
        catch (KuduException e) {
            throw new KuduConnectorException((SeaTunnelErrorCode)CommonErrorCode.TABLE_SCHEMA_GET_FAILED, "get table Columns Schemas Failed");
        }
        return columns;
    }

    public static SeaTunnelRow getSeaTunnelRowData(RowResult rs, SeaTunnelRowType typeInfo) throws SQLException {
        ArrayList<Boolean> fields = new ArrayList<Boolean>();
        SeaTunnelDataType[] seaTunnelDataTypes = typeInfo.getFieldTypes();
        for (int i = 0; i < seaTunnelDataTypes.length; ++i) {
            Object seatunnelField;
            SeaTunnelDataType seaTunnelDataType = seaTunnelDataTypes[i];
            if (null == rs.getObject(i)) {
                seatunnelField = null;
            } else if (BasicType.BOOLEAN_TYPE.equals((Object)seaTunnelDataType)) {
                seatunnelField = rs.getBoolean(i);
            } else if (BasicType.BYTE_TYPE.equals((Object)seaTunnelDataType)) {
                seatunnelField = rs.getByte(i);
            } else if (BasicType.SHORT_TYPE.equals((Object)seaTunnelDataType)) {
                seatunnelField = rs.getShort(i);
            } else if (BasicType.INT_TYPE.equals((Object)seaTunnelDataType)) {
                seatunnelField = rs.getInt(i);
            } else if (BasicType.LONG_TYPE.equals((Object)seaTunnelDataType)) {
                seatunnelField = rs.getLong(i);
            } else if (seaTunnelDataType instanceof DecimalType) {
                Object value = rs.getObject(i);
                seatunnelField = value instanceof BigInteger ? new BigDecimal((BigInteger)value, 0) : value;
            } else if (BasicType.FLOAT_TYPE.equals((Object)seaTunnelDataType)) {
                seatunnelField = Float.valueOf(rs.getFloat(i));
            } else if (BasicType.DOUBLE_TYPE.equals((Object)seaTunnelDataType)) {
                seatunnelField = rs.getDouble(i);
            } else if (BasicType.STRING_TYPE.equals((Object)seaTunnelDataType)) {
                seatunnelField = rs.getString(i);
            } else {
                throw new KuduConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unsupported data type: " + seaTunnelDataType);
            }
            fields.add((Boolean)seatunnelField);
        }
        return new SeaTunnelRow(fields.toArray());
    }

    public SeaTunnelRowType getSeaTunnelRowType(List<ColumnSchema> columnSchemaList) {
        ArrayList seaTunnelDataTypes = new ArrayList();
        ArrayList<String> fieldNames = new ArrayList<String>();
        try {
            for (int i = 0; i < columnSchemaList.size(); ++i) {
                fieldNames.add(columnSchemaList.get(i).getName());
                seaTunnelDataTypes.add(KuduTypeMapper.mapping(columnSchemaList, i));
            }
        }
        catch (Exception e) {
            throw new KuduConnectorException((SeaTunnelErrorCode)CommonErrorCode.TABLE_SCHEMA_GET_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", new Object[]{"Kudu", PluginType.SOURCE, ExceptionUtils.getMessage(e)}));
        }
        return new SeaTunnelRowType(fieldNames.toArray(new String[fieldNames.size()]), seaTunnelDataTypes.toArray(new SeaTunnelDataType[seaTunnelDataTypes.size()]));
    }

    public void openInputFormat() {
        KuduClient.KuduClientBuilder kuduClientBuilder = new KuduClient.KuduClientBuilder(this.kuduMaster);
        kuduClientBuilder.defaultOperationTimeoutMs(18000L);
        this.kuduClient = kuduClientBuilder.build();
        log.info("The Kudu client is successfully initialized", (Object)this.kuduMaster, (Object)this.kuduClient);
    }

    public KuduScanner getKuduBuildSplit(int lowerBound, int upperBound) {
        KuduScanner kuduScanner = null;
        try {
            KuduScanner.KuduScannerBuilder kuduScannerBuilder = this.kuduClient.newScannerBuilder(this.kuduClient.openTable(this.tableName));
            kuduScannerBuilder.setProjectedColumnNames(this.columnsList);
            KuduPredicate lowerPred = KuduPredicate.newComparisonPredicate(this.schema.getColumn("" + this.keyColumn), KuduPredicate.ComparisonOp.GREATER_EQUAL, lowerBound);
            KuduPredicate upperPred = KuduPredicate.newComparisonPredicate(this.schema.getColumn("" + this.keyColumn), KuduPredicate.ComparisonOp.LESS, upperBound);
            kuduScanner = ((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)kuduScannerBuilder.addPredicate(lowerPred)).addPredicate(upperPred)).build();
        }
        catch (KuduException e) {
            throw new KuduConnectorException((SeaTunnelErrorCode)KuduConnectorErrorCode.GET_KUDUSCAN_OBJECT_FAILED, (Throwable)e);
        }
        return kuduScanner;
    }

    public void closeInputFormat() {
        if (this.kuduClient != null) {
            try {
                this.kuduClient.close();
            }
            catch (KuduException e) {
                throw new KuduConnectorException((SeaTunnelErrorCode)KuduConnectorErrorCode.CLOSE_KUDU_CLIENT_FAILED, (Throwable)e);
            }
            finally {
                this.kuduClient = null;
            }
        }
    }
}

